<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * BABE_Locales Class.
 * @class 		BABE_Locales
 * @version		1.3.31
 * @author 		Booking Algorithms
 */

class BABE_Locales {

    /**
     * Returns an array of countries and codes.
     *
     * @see https://github.com/unicode-org/cldr/blob/master/common/subdivisions/en.xml
     * @return array
     */
    public static function countries() {
        return apply_filters( 'babe_countries', [
            'AF' => __( 'Afghanistan', 'ba-book-everything' ),
            'AX' => __( 'Åland Islands', 'ba-book-everything' ),
            'AL' => __( 'Albania', 'ba-book-everything' ),
            'DZ' => __( 'Algeria', 'ba-book-everything' ),
            'AS' => __( 'American Samoa', 'ba-book-everything' ),
            'AD' => __( 'Andorra', 'ba-book-everything' ),
            'AO' => __( 'Angola', 'ba-book-everything' ),
            'AI' => __( 'Anguilla', 'ba-book-everything' ),
            'AQ' => __( 'Antarctica', 'ba-book-everything' ),
            'AG' => __( 'Antigua and Barbuda', 'ba-book-everything' ),
            'AR' => __( 'Argentina', 'ba-book-everything' ),
            'AM' => __( 'Armenia', 'ba-book-everything' ),
            'AW' => __( 'Aruba', 'ba-book-everything' ),
            'AU' => __( 'Australia', 'ba-book-everything' ),
            'AT' => __( 'Austria', 'ba-book-everything' ),
            'AZ' => __( 'Azerbaijan', 'ba-book-everything' ),
            'BS' => __( 'Bahamas', 'ba-book-everything' ),
            'BH' => __( 'Bahrain', 'ba-book-everything' ),
            'BD' => __( 'Bangladesh', 'ba-book-everything' ),
            'BB' => __( 'Barbados', 'ba-book-everything' ),
            'BY' => __( 'Belarus', 'ba-book-everything' ),
            'BE' => __( 'Belgium', 'ba-book-everything' ),
            'PW' => __( 'Belau', 'ba-book-everything' ),
            'BZ' => __( 'Belize', 'ba-book-everything' ),
            'BJ' => __( 'Benin', 'ba-book-everything' ),
            'BM' => __( 'Bermuda', 'ba-book-everything' ),
            'BT' => __( 'Bhutan', 'ba-book-everything' ),
            'BO' => __( 'Bolivia', 'ba-book-everything' ),
            'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'ba-book-everything' ),
            'BA' => __( 'Bosnia and Herzegovina', 'ba-book-everything' ),
            'BW' => __( 'Botswana', 'ba-book-everything' ),
            'BV' => __( 'Bouvet Island', 'ba-book-everything' ),
            'BR' => __( 'Brazil', 'ba-book-everything' ),
            'IO' => __( 'British Indian Ocean Territory', 'ba-book-everything' ),
            'BN' => __( 'Brunei', 'ba-book-everything' ),
            'BG' => __( 'Bulgaria', 'ba-book-everything' ),
            'BF' => __( 'Burkina Faso', 'ba-book-everything' ),
            'BI' => __( 'Burundi', 'ba-book-everything' ),
            'KH' => __( 'Cambodia', 'ba-book-everything' ),
            'CM' => __( 'Cameroon', 'ba-book-everything' ),
            'CA' => __( 'Canada', 'ba-book-everything' ),
            'CV' => __( 'Cape Verde', 'ba-book-everything' ),
            'KY' => __( 'Cayman Islands', 'ba-book-everything' ),
            'CF' => __( 'Central African Republic', 'ba-book-everything' ),
            'TD' => __( 'Chad', 'ba-book-everything' ),
            'CL' => __( 'Chile', 'ba-book-everything' ),
            'CN' => __( 'China', 'ba-book-everything' ),
            'CX' => __( 'Christmas Island', 'ba-book-everything' ),
            'CC' => __( 'Cocos (Keeling) Islands', 'ba-book-everything' ),
            'CO' => __( 'Colombia', 'ba-book-everything' ),
            'KM' => __( 'Comoros', 'ba-book-everything' ),
            'CG' => __( 'Congo (Brazzaville)', 'ba-book-everything' ),
            'CD' => __( 'Congo (Kinshasa)', 'ba-book-everything' ),
            'CK' => __( 'Cook Islands', 'ba-book-everything' ),
            'CR' => __( 'Costa Rica', 'ba-book-everything' ),
            'HR' => __( 'Croatia', 'ba-book-everything' ),
            'CU' => __( 'Cuba', 'ba-book-everything' ),
            'CW' => __( 'Cura&ccedil;ao', 'ba-book-everything' ),
            'CY' => __( 'Cyprus', 'ba-book-everything' ),
            'CZ' => __( 'Czech Republic', 'ba-book-everything' ),
            'DK' => __( 'Denmark', 'ba-book-everything' ),
            'DJ' => __( 'Djibouti', 'ba-book-everything' ),
            'DM' => __( 'Dominica', 'ba-book-everything' ),
            'DO' => __( 'Dominican Republic', 'ba-book-everything' ),
            'EC' => __( 'Ecuador', 'ba-book-everything' ),
            'EG' => __( 'Egypt', 'ba-book-everything' ),
            'SV' => __( 'El Salvador', 'ba-book-everything' ),
            'GQ' => __( 'Equatorial Guinea', 'ba-book-everything' ),
            'ER' => __( 'Eritrea', 'ba-book-everything' ),
            'EE' => __( 'Estonia', 'ba-book-everything' ),
            'ET' => __( 'Ethiopia', 'ba-book-everything' ),
            'FK' => __( 'Falkland Islands', 'ba-book-everything' ),
            'FO' => __( 'Faroe Islands', 'ba-book-everything' ),
            'FJ' => __( 'Fiji', 'ba-book-everything' ),
            'FI' => __( 'Finland', 'ba-book-everything' ),
            'FR' => __( 'France', 'ba-book-everything' ),
            'GF' => __( 'French Guiana', 'ba-book-everything' ),
            'PF' => __( 'French Polynesia', 'ba-book-everything' ),
            'TF' => __( 'French Southern Territories', 'ba-book-everything' ),
            'GA' => __( 'Gabon', 'ba-book-everything' ),
            'GM' => __( 'Gambia', 'ba-book-everything' ),
            'GE' => __( 'Georgia', 'ba-book-everything' ),
            'DE' => __( 'Germany', 'ba-book-everything' ),
            'GH' => __( 'Ghana', 'ba-book-everything' ),
            'GI' => __( 'Gibraltar', 'ba-book-everything' ),
            'GR' => __( 'Greece', 'ba-book-everything' ),
            'GL' => __( 'Greenland', 'ba-book-everything' ),
            'GD' => __( 'Grenada', 'ba-book-everything' ),
            'GP' => __( 'Guadeloupe', 'ba-book-everything' ),
            'GU' => __( 'Guam', 'ba-book-everything' ),
            'GT' => __( 'Guatemala', 'ba-book-everything' ),
            'GG' => __( 'Guernsey', 'ba-book-everything' ),
            'GN' => __( 'Guinea', 'ba-book-everything' ),
            'GW' => __( 'Guinea-Bissau', 'ba-book-everything' ),
            'GY' => __( 'Guyana', 'ba-book-everything' ),
            'HT' => __( 'Haiti', 'ba-book-everything' ),
            'HM' => __( 'Heard Island and McDonald Islands', 'ba-book-everything' ),
            'HN' => __( 'Honduras', 'ba-book-everything' ),
            'HK' => __( 'Hong Kong', 'ba-book-everything' ),
            'HU' => __( 'Hungary', 'ba-book-everything' ),
            'IS' => __( 'Iceland', 'ba-book-everything' ),
            'IN' => __( 'India', 'ba-book-everything' ),
            'ID' => __( 'Indonesia', 'ba-book-everything' ),
            'IR' => __( 'Iran', 'ba-book-everything' ),
            'IQ' => __( 'Iraq', 'ba-book-everything' ),
            'IE' => __( 'Ireland', 'ba-book-everything' ),
            'IM' => __( 'Isle of Man', 'ba-book-everything' ),
            'IL' => __( 'Israel', 'ba-book-everything' ),
            'IT' => __( 'Italy', 'ba-book-everything' ),
            'CI' => __( 'Ivory Coast', 'ba-book-everything' ),
            'JM' => __( 'Jamaica', 'ba-book-everything' ),
            'JP' => __( 'Japan', 'ba-book-everything' ),
            'JE' => __( 'Jersey', 'ba-book-everything' ),
            'JO' => __( 'Jordan', 'ba-book-everything' ),
            'KZ' => __( 'Kazakhstan', 'ba-book-everything' ),
            'KE' => __( 'Kenya', 'ba-book-everything' ),
            'KI' => __( 'Kiribati', 'ba-book-everything' ),
            'KW' => __( 'Kuwait', 'ba-book-everything' ),
            'KG' => __( 'Kyrgyzstan', 'ba-book-everything' ),
            'LA' => __( 'Laos', 'ba-book-everything' ),
            'LV' => __( 'Latvia', 'ba-book-everything' ),
            'LB' => __( 'Lebanon', 'ba-book-everything' ),
            'LS' => __( 'Lesotho', 'ba-book-everything' ),
            'LR' => __( 'Liberia', 'ba-book-everything' ),
            'LY' => __( 'Libya', 'ba-book-everything' ),
            'LI' => __( 'Liechtenstein', 'ba-book-everything' ),
            'LT' => __( 'Lithuania', 'ba-book-everything' ),
            'LU' => __( 'Luxembourg', 'ba-book-everything' ),
            'MO' => __( 'Macao', 'ba-book-everything' ),
            'MK' => __( 'North Macedonia', 'ba-book-everything' ),
            'MG' => __( 'Madagascar', 'ba-book-everything' ),
            'MW' => __( 'Malawi', 'ba-book-everything' ),
            'MY' => __( 'Malaysia', 'ba-book-everything' ),
            'MV' => __( 'Maldives', 'ba-book-everything' ),
            'ML' => __( 'Mali', 'ba-book-everything' ),
            'MT' => __( 'Malta', 'ba-book-everything' ),
            'MH' => __( 'Marshall Islands', 'ba-book-everything' ),
            'MQ' => __( 'Martinique', 'ba-book-everything' ),
            'MR' => __( 'Mauritania', 'ba-book-everything' ),
            'MU' => __( 'Mauritius', 'ba-book-everything' ),
            'YT' => __( 'Mayotte', 'ba-book-everything' ),
            'MX' => __( 'Mexico', 'ba-book-everything' ),
            'FM' => __( 'Micronesia', 'ba-book-everything' ),
            'MD' => __( 'Moldova', 'ba-book-everything' ),
            'MC' => __( 'Monaco', 'ba-book-everything' ),
            'MN' => __( 'Mongolia', 'ba-book-everything' ),
            'ME' => __( 'Montenegro', 'ba-book-everything' ),
            'MS' => __( 'Montserrat', 'ba-book-everything' ),
            'MA' => __( 'Morocco', 'ba-book-everything' ),
            'MZ' => __( 'Mozambique', 'ba-book-everything' ),
            'MM' => __( 'Myanmar', 'ba-book-everything' ),
            'NA' => __( 'Namibia', 'ba-book-everything' ),
            'NR' => __( 'Nauru', 'ba-book-everything' ),
            'NP' => __( 'Nepal', 'ba-book-everything' ),
            'NL' => __( 'Netherlands', 'ba-book-everything' ),
            'NC' => __( 'New Caledonia', 'ba-book-everything' ),
            'NZ' => __( 'New Zealand', 'ba-book-everything' ),
            'NI' => __( 'Nicaragua', 'ba-book-everything' ),
            'NE' => __( 'Niger', 'ba-book-everything' ),
            'NG' => __( 'Nigeria', 'ba-book-everything' ),
            'NU' => __( 'Niue', 'ba-book-everything' ),
            'NF' => __( 'Norfolk Island', 'ba-book-everything' ),
            'MP' => __( 'Northern Mariana Islands', 'ba-book-everything' ),
            'KP' => __( 'North Korea', 'ba-book-everything' ),
            'NO' => __( 'Norway', 'ba-book-everything' ),
            'OM' => __( 'Oman', 'ba-book-everything' ),
            'PK' => __( 'Pakistan', 'ba-book-everything' ),
            'PS' => __( 'Palestinian Territory', 'ba-book-everything' ),
            'PA' => __( 'Panama', 'ba-book-everything' ),
            'PG' => __( 'Papua New Guinea', 'ba-book-everything' ),
            'PY' => __( 'Paraguay', 'ba-book-everything' ),
            'PE' => __( 'Peru', 'ba-book-everything' ),
            'PH' => __( 'Philippines', 'ba-book-everything' ),
            'PN' => __( 'Pitcairn', 'ba-book-everything' ),
            'PL' => __( 'Poland', 'ba-book-everything' ),
            'PT' => __( 'Portugal', 'ba-book-everything' ),
            'PR' => __( 'Puerto Rico', 'ba-book-everything' ),
            'QA' => __( 'Qatar', 'ba-book-everything' ),
            'RE' => __( 'Reunion', 'ba-book-everything' ),
            'RO' => __( 'Romania', 'ba-book-everything' ),
            'RU' => __( 'Russia', 'ba-book-everything' ),
            'RW' => __( 'Rwanda', 'ba-book-everything' ),
            'BL' => __( 'Saint Barth&eacute;lemy', 'ba-book-everything' ),
            'SH' => __( 'Saint Helena', 'ba-book-everything' ),
            'KN' => __( 'Saint Kitts and Nevis', 'ba-book-everything' ),
            'LC' => __( 'Saint Lucia', 'ba-book-everything' ),
            'MF' => __( 'Saint Martin (French part)', 'ba-book-everything' ),
            'SX' => __( 'Saint Martin (Dutch part)', 'ba-book-everything' ),
            'PM' => __( 'Saint Pierre and Miquelon', 'ba-book-everything' ),
            'VC' => __( 'Saint Vincent and the Grenadines', 'ba-book-everything' ),
            'SM' => __( 'San Marino', 'ba-book-everything' ),
            'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'ba-book-everything' ),
            'SA' => __( 'Saudi Arabia', 'ba-book-everything' ),
            'SN' => __( 'Senegal', 'ba-book-everything' ),
            'RS' => __( 'Serbia', 'ba-book-everything' ),
            'SC' => __( 'Seychelles', 'ba-book-everything' ),
            'SL' => __( 'Sierra Leone', 'ba-book-everything' ),
            'SG' => __( 'Singapore', 'ba-book-everything' ),
            'SK' => __( 'Slovakia', 'ba-book-everything' ),
            'SI' => __( 'Slovenia', 'ba-book-everything' ),
            'SB' => __( 'Solomon Islands', 'ba-book-everything' ),
            'SO' => __( 'Somalia', 'ba-book-everything' ),
            'ZA' => __( 'South Africa', 'ba-book-everything' ),
            'GS' => __( 'South Georgia/Sandwich Islands', 'ba-book-everything' ),
            'KR' => __( 'South Korea', 'ba-book-everything' ),
            'SS' => __( 'South Sudan', 'ba-book-everything' ),
            'ES' => __( 'Spain', 'ba-book-everything' ),
            'LK' => __( 'Sri Lanka', 'ba-book-everything' ),
            'SD' => __( 'Sudan', 'ba-book-everything' ),
            'SR' => __( 'Suriname', 'ba-book-everything' ),
            'SJ' => __( 'Svalbard and Jan Mayen', 'ba-book-everything' ),
            'SZ' => __( 'Swaziland', 'ba-book-everything' ),
            'SE' => __( 'Sweden', 'ba-book-everything' ),
            'CH' => __( 'Switzerland', 'ba-book-everything' ),
            'SY' => __( 'Syria', 'ba-book-everything' ),
            'TW' => __( 'Taiwan', 'ba-book-everything' ),
            'TJ' => __( 'Tajikistan', 'ba-book-everything' ),
            'TZ' => __( 'Tanzania', 'ba-book-everything' ),
            'TH' => __( 'Thailand', 'ba-book-everything' ),
            'TL' => __( 'Timor-Leste', 'ba-book-everything' ),
            'TG' => __( 'Togo', 'ba-book-everything' ),
            'TK' => __( 'Tokelau', 'ba-book-everything' ),
            'TO' => __( 'Tonga', 'ba-book-everything' ),
            'TT' => __( 'Trinidad and Tobago', 'ba-book-everything' ),
            'TN' => __( 'Tunisia', 'ba-book-everything' ),
            'TR' => __( 'Turkey', 'ba-book-everything' ),
            'TM' => __( 'Turkmenistan', 'ba-book-everything' ),
            'TC' => __( 'Turks and Caicos Islands', 'ba-book-everything' ),
            'TV' => __( 'Tuvalu', 'ba-book-everything' ),
            'UG' => __( 'Uganda', 'ba-book-everything' ),
            'UA' => __( 'Ukraine', 'ba-book-everything' ),
            'AE' => __( 'United Arab Emirates', 'ba-book-everything' ),
            'GB' => __( 'United Kingdom (UK)', 'ba-book-everything' ),
            'US' => __( 'United States (US)', 'ba-book-everything' ),
            'UM' => __( 'United States (US) Minor Outlying Islands', 'ba-book-everything' ),
            'UY' => __( 'Uruguay', 'ba-book-everything' ),
            'UZ' => __( 'Uzbekistan', 'ba-book-everything' ),
            'VU' => __( 'Vanuatu', 'ba-book-everything' ),
            'VA' => __( 'Vatican', 'ba-book-everything' ),
            'VE' => __( 'Venezuela', 'ba-book-everything' ),
            'VN' => __( 'Vietnam', 'ba-book-everything' ),
            'VG' => __( 'Virgin Islands (British)', 'ba-book-everything' ),
            'VI' => __( 'Virgin Islands (US)', 'ba-book-everything' ),
            'WF' => __( 'Wallis and Futuna', 'ba-book-everything' ),
            'EH' => __( 'Western Sahara', 'ba-book-everything' ),
            'WS' => __( 'Samoa', 'ba-book-everything' ),
            'YE' => __( 'Yemen', 'ba-book-everything' ),
            'ZM' => __( 'Zambia', 'ba-book-everything' ),
            'ZW' => __( 'Zimbabwe', 'ba-book-everything' ),
        ]);
    }

    /**
     * Returns an array of country codes ALPHA-2 => ALPHA-3
     * @return array
     */
    public static function countries_alpha2_to_alpha3() {
        return apply_filters( 'babe_countries_alpha2_to_alpha3', [
            'AF' => 'AFG',
            'AX' => 'ALA',
            'AL' => 'ALB',
            'DZ' => 'DZA',
            'AS' => 'ASM',
            'AD' => 'AND',
            'AO' => 'AGO',
            'AI' => 'AIA',
            'AQ' => 'ATA',
            'AG' => 'ATG',
            'AR' => 'ARG',
            'AM' => 'ARM',
            'AW' => 'ABW',
            'AU' => 'AUS',
            'AT' => 'AUT',
            'AZ' => 'AZE',
            'BS' => 'BHS',
            'BH' => 'BHR',
            'BD' => 'BGD',
            'BB' => 'BRB',
            'BY' => 'BLR',
            'BE' => 'BEL',
            'BZ' => 'BLZ',
            'BJ' => 'BEN',
            'BM' => 'BMU',
            'BT' => 'BTN',
            'BO' => 'BOL',
            'BQ' => 'BES',
            'BA' => 'BIH',
            'BW' => 'BWA',
            'BV' => 'BVT',
            'BR' => 'BRA',
            'IO' => 'IOT',
            'BN' => 'BRN',
            'BG' => 'BGR',
            'BF' => 'BFA',
            'BI' => 'BDI',
            'KH' => 'KHM',
            'CM' => 'CMR',
            'CA' => 'CAN',
            'CV' => 'CPV',
            'KY' => 'CYM',
            'CF' => 'CAF',
            'TD' => 'TCD',
            'CL' => 'CHL',
            'CN' => 'CHN',
            'CX' => 'CXR',
            'CC' => 'CCK',
            'CO' => 'COL',
            'KM' => 'COM',
            'CG' => 'COG',
            'CD' => 'COD',
            'CK' => 'COK',
            'CR' => 'CRI',
            'CI' => 'CIV',
            'HR' => 'HRV',
            'CU' => 'CUB',
            'CW' => 'CUW',
            'CY' => 'CYP',
            'CZ' => 'CZE',
            'DK' => 'DNK',
            'DJ' => 'DJI',
            'DM' => 'DMA',
            'DO' => 'DOM',
            'EC' => 'ECU',
            'EG' => 'EGY',
            'SV' => 'SLV',
            'GQ' => 'GNQ',
            'ER' => 'ERI',
            'EE' => 'EST',
            'ET' => 'ETH',
            'FK' => 'FLK',
            'FO' => 'FRO',
            'FJ' => 'FJI',
            'FI' => 'FIN',
            'FR' => 'FRA',
            'GF' => 'GUF',
            'PF' => 'PYF',
            'TF' => 'ATF',
            'GA' => 'GAB',
            'GM' => 'GMB',
            'GE' => 'GEO',
            'DE' => 'DEU',
            'GH' => 'GHA',
            'GI' => 'GIB',
            'GR' => 'GRC',
            'GL' => 'GRL',
            'GD' => 'GRD',
            'GP' => 'GLP',
            'GU' => 'GUM',
            'GT' => 'GTM',
            'GG' => 'GGY',
            'GN' => 'GIN',
            'GW' => 'GNB',
            'GY' => 'GUY',
            'HT' => 'HTI',
            'HM' => 'HMD',
            'VA' => 'VAT',
            'HN' => 'HND',
            'HK' => 'HKG',
            'HU' => 'HUN',
            'IS' => 'ISL',
            'IN' => 'IND',
            'ID' => 'IDN',
            'IR' => 'IRN',
            'IQ' => 'IRQ',
            'IE' => 'IRL',
            'IM' => 'IMN',
            'IL' => 'ISR',
            'IT' => 'ITA',
            'JM' => 'JAM',
            'JP' => 'JPN',
            'JE' => 'JEY',
            'JO' => 'JOR',
            'KZ' => 'KAZ',
            'KE' => 'KEN',
            'KI' => 'KIR',
            'KP' => 'PRK',
            'KR' => 'KOR',
            'XK' => 'XKX',
            'KW' => 'KWT',
            'KG' => 'KGZ',
            'LA' => 'LAO',
            'LV' => 'LVA',
            'LB' => 'LBN',
            'LS' => 'LSO',
            'LR' => 'LBR',
            'LY' => 'LBY',
            'LI' => 'LIE',
            'LT' => 'LTU',
            'LU' => 'LUX',
            'MO' => 'MAC',
            'MK' => 'MKD',
            'MG' => 'MDG',
            'MW' => 'MWI',
            'MY' => 'MYS',
            'MV' => 'MDV',
            'ML' => 'MLI',
            'MT' => 'MLT',
            'MH' => 'MHL',
            'MQ' => 'MTQ',
            'MR' => 'MRT',
            'MU' => 'MUS',
            'YT' => 'MYT',
            'MX' => 'MEX',
            'FM' => 'FSM',
            'MD' => 'MDA',
            'MC' => 'MCO',
            'MN' => 'MNG',
            'ME' => 'MNE',
            'MS' => 'MSR',
            'MA' => 'MAR',
            'MZ' => 'MOZ',
            'MM' => 'MMR',
            'NA' => 'NAM',
            'NR' => 'NRU',
            'NP' => 'NPL',
            'NL' => 'NLD',
            'AN' => 'ANT',
            'NC' => 'NCL',
            'NZ' => 'NZL',
            'NI' => 'NIC',
            'NE' => 'NER',
            'NG' => 'NGA',
            'NU' => 'NIU',
            'NF' => 'NFK',
            'MP' => 'MNP',
            'NO' => 'NOR',
            'OM' => 'OMN',
            'PK' => 'PAK',
            'PW' => 'PLW',
            'PS' => 'PSE',
            'PA' => 'PAN',
            'PG' => 'PNG',
            'PY' => 'PRY',
            'PE' => 'PER',
            'PH' => 'PHL',
            'PN' => 'PCN',
            'PL' => 'POL',
            'PT' => 'PRT',
            'PR' => 'PRI',
            'QA' => 'QAT',
            'RE' => 'REU',
            'RO' => 'ROM',
            'RU' => 'RUS',
            'RW' => 'RWA',
            'BL' => 'BLM',
            'SH' => 'SHN',
            'KN' => 'KNA',
            'LC' => 'LCA',
            'MF' => 'MAF',
            'PM' => 'SPM',
            'VC' => 'VCT',
            'WS' => 'WSM',
            'SM' => 'SMR',
            'ST' => 'STP',
            'SA' => 'SAU',
            'SN' => 'SEN',
            'RS' => 'SRB',
            'CS' => 'SCG',
            'SC' => 'SYC',
            'SL' => 'SLE',
            'SG' => 'SGP',
            'SX' => 'SXM',
            'SK' => 'SVK',
            'SI' => 'SVN',
            'SB' => 'SLB',
            'SO' => 'SOM',
            'ZA' => 'ZAF',
            'GS' => 'SGS',
            'SS' => 'SSD',
            'ES' => 'ESP',
            'LK' => 'LKA',
            'SD' => 'SDN',
            'SR' => 'SUR',
            'SJ' => 'SJM',
            'SZ' => 'SWZ',
            'SE' => 'SWE',
            'CH' => 'CHE',
            'SY' => 'SYR',
            'TW' => 'TWN',
            'TJ' => 'TJK',
            'TZ' => 'TZA',
            'TH' => 'THA',
            'TL' => 'TLS',
            'TG' => 'TGO',
            'TK' => 'TKL',
            'TO' => 'TON',
            'TT' => 'TTO',
            'TN' => 'TUN',
            'TR' => 'TUR',
            'TM' => 'TKM',
            'TC' => 'TCA',
            'TV' => 'TUV',
            'UG' => 'UGA',
            'UA' => 'UKR',
            'AE' => 'ARE',
            'GB' => 'GBR',
            'US' => 'USA',
            'UM' => 'UMI',
            'UY' => 'URY',
            'UZ' => 'UZB',
            'VU' => 'VUT',
            'VE' => 'VEN',
            'VN' => 'VNM',
            'VG' => 'VGB',
            'VI' => 'VIR',
            'WF' => 'WLF',
            'EH' => 'ESH',
            'YE' => 'YEM',
            'ZM' => 'ZMB',
            'ZW' => 'ZWE',
        ]);
    }

    /**
     * Returns an array of calling codes.
     * @return array
     */
    public static function phone_codes() {

        return apply_filters( 'babe_phone_codes', [
            'BD' => '+880',
            'BE' => '+32',
            'BF' => '+226',
            'BG' => '+359',
            'BA' => '+387',
            'BB' => '+1246',
            'WF' => '+681',
            'BL' => '+590',
            'BM' => '+1441',
            'BN' => '+673',
            'BO' => '+591',
            'BH' => '+973',
            'BI' => '+257',
            'BJ' => '+229',
            'BT' => '+975',
            'JM' => '+1876',
            'BV' => '',
            'BW' => '+267',
            'WS' => '+685',
            'BQ' => '+599',
            'BR' => '+55',
            'BS' => '+1242',
            'JE' => '+441534',
            'BY' => '+375',
            'BZ' => '+501',
            'RU' => '+7',
            'RW' => '+250',
            'RS' => '+381',
            'TL' => '+670',
            'RE' => '+262',
            'TM' => '+993',
            'TJ' => '+992',
            'RO' => '+40',
            'TK' => '+690',
            'GW' => '+245',
            'GU' => '+1671',
            'GT' => '+502',
            'GS' => '',
            'GR' => '+30',
            'GQ' => '+240',
            'GP' => '+590',
            'JP' => '+81',
            'GY' => '+592',
            'GG' => '+441481',
            'GF' => '+594',
            'GE' => '+995',
            'GD' => '+1473',
            'GB' => '+44',
            'GA' => '+241',
            'SV' => '+503',
            'GN' => '+224',
            'GM' => '+220',
            'GL' => '+299',
            'GI' => '+350',
            'GH' => '+233',
            'OM' => '+968',
            'TN' => '+216',
            'JO' => '+962',
            'HR' => '+385',
            'HT' => '+509',
            'HU' => '+36',
            'HK' => '+852',
            'HN' => '+504',
            'HM' => '',
            'VE' => '+58',
            'PR' => [
                '+1787',
                '+1939',
            ],
            'PS' => '+970',
            'PW' => '+680',
            'PT' => '+351',
            'SJ' => '+47',
            'PY' => '+595',
            'IQ' => '+964',
            'PA' => '+507',
            'PF' => '+689',
            'PG' => '+675',
            'PE' => '+51',
            'PK' => '+92',
            'PH' => '+63',
            'PN' => '+870',
            'PL' => '+48',
            'PM' => '+508',
            'ZM' => '+260',
            'EH' => '+212',
            'EE' => '+372',
            'EG' => '+20',
            'ZA' => '+27',
            'EC' => '+593',
            'IT' => '+39',
            'VN' => '+84',
            'SB' => '+677',
            'ET' => '+251',
            'SO' => '+252',
            'ZW' => '+263',
            'SA' => '+966',
            'ES' => '+34',
            'ER' => '+291',
            'ME' => '+382',
            'MD' => '+373',
            'MG' => '+261',
            'MF' => '+590',
            'MA' => '+212',
            'MC' => '+377',
            'UZ' => '+998',
            'MM' => '+95',
            'ML' => '+223',
            'MO' => '+853',
            'MN' => '+976',
            'MH' => '+692',
            'MK' => '+389',
            'MU' => '+230',
            'MT' => '+356',
            'MW' => '+265',
            'MV' => '+960',
            'MQ' => '+596',
            'MP' => '+1670',
            'MS' => '+1664',
            'MR' => '+222',
            'IM' => '+441624',
            'UG' => '+256',
            'TZ' => '+255',
            'MY' => '+60',
            'MX' => '+52',
            'IL' => '+972',
            'FR' => '+33',
            'IO' => '+246',
            'SH' => '+290',
            'FI' => '+358',
            'FJ' => '+679',
            'FK' => '+500',
            'FM' => '+691',
            'FO' => '+298',
            'NI' => '+505',
            'NL' => '+31',
            'NO' => '+47',
            'NA' => '+264',
            'VU' => '+678',
            'NC' => '+687',
            'NE' => '+227',
            'NF' => '+672',
            'NG' => '+234',
            'NZ' => '+64',
            'NP' => '+977',
            'NR' => '+674',
            'NU' => '+683',
            'CK' => '+682',
            'XK' => '',
            'CI' => '+225',
            'CH' => '+41',
            'CO' => '+57',
            'CN' => '+86',
            'CM' => '+237',
            'CL' => '+56',
            'CC' => '+61',
            'CA' => '+1',
            'CG' => '+242',
            'CF' => '+236',
            'CD' => '+243',
            'CZ' => '+420',
            'CY' => '+357',
            'CX' => '+61',
            'CR' => '+506',
            'CW' => '+599',
            'CV' => '+238',
            'CU' => '+53',
            'SZ' => '+268',
            'SY' => '+963',
            'SX' => '+599',
            'KG' => '+996',
            'KE' => '+254',
            'SS' => '+211',
            'SR' => '+597',
            'KI' => '+686',
            'KH' => '+855',
            'KN' => '+1869',
            'KM' => '+269',
            'ST' => '+239',
            'SK' => '+421',
            'KR' => '+82',
            'SI' => '+386',
            'KP' => '+850',
            'KW' => '+965',
            'SN' => '+221',
            'SM' => '+378',
            'SL' => '+232',
            'SC' => '+248',
            'KZ' => '+7',
            'KY' => '+1345',
            'SG' => '+65',
            'SE' => '+46',
            'SD' => '+249',
            'DO' => [
                '+1809',
                '+1829',
                '+1849',
            ],
            'DM' => '+1767',
            'DJ' => '+253',
            'DK' => '+45',
            'VG' => '+1284',
            'DE' => '+49',
            'YE' => '+967',
            'DZ' => '+213',
            'US' => '+1',
            'UY' => '+598',
            'YT' => '+262',
            'UM' => '+1',
            'LB' => '+961',
            'LC' => '+1758',
            'LA' => '+856',
            'TV' => '+688',
            'TW' => '+886',
            'TT' => '+1868',
            'TR' => '+90',
            'LK' => '+94',
            'LI' => '+423',
            'LV' => '+371',
            'TO' => '+676',
            'LT' => '+370',
            'LU' => '+352',
            'LR' => '+231',
            'LS' => '+266',
            'TH' => '+66',
            'TF' => '',
            'TG' => '+228',
            'TD' => '+235',
            'TC' => '+1649',
            'LY' => '+218',
            'VA' => '+379',
            'VC' => '+1784',
            'AE' => '+971',
            'AD' => '+376',
            'AG' => '+1268',
            'AF' => '+93',
            'AI' => '+1264',
            'VI' => '+1340',
            'IS' => '+354',
            'IR' => '+98',
            'AM' => '+374',
            'AL' => '+355',
            'AO' => '+244',
            'AQ' => '',
            'AS' => '+1684',
            'AR' => '+54',
            'AU' => '+61',
            'AT' => '+43',
            'AW' => '+297',
            'IN' => '+91',
            'AX' => '+35818',
            'AZ' => '+994',
            'IE' => '+353',
            'ID' => '+62',
            'UA' => '+380',
            'QA' => '+974',
            'MZ' => '+258',
        ]);
    }

    /**
     * Returns an array of country states.
     * Countries defined with empty arrays have no states.
     * @return array
     */
    public static function states() {

        return apply_filters( 'babe_states', [
            'AF' => array(),
            'AO' => array( // Angola states.
                'BGO' => __( 'Bengo', 'ba-book-everything' ),
                'BLU' => __( 'Benguela', 'ba-book-everything' ),
                'BIE' => __( 'Bié', 'ba-book-everything' ),
                'CAB' => __( 'Cabinda', 'ba-book-everything' ),
                'CNN' => __( 'Cunene', 'ba-book-everything' ),
                'HUA' => __( 'Huambo', 'ba-book-everything' ),
                'HUI' => __( 'Huíla', 'ba-book-everything' ),
                'CCU' => __( 'Kuando Kubango', 'ba-book-everything' ),
                'CNO' => __( 'Kwanza-Norte', 'ba-book-everything' ),
                'CUS' => __( 'Kwanza-Sul', 'ba-book-everything' ),
                'LUA' => __( 'Luanda', 'ba-book-everything' ),
                'LNO' => __( 'Lunda-Norte', 'ba-book-everything' ),
                'LSU' => __( 'Lunda-Sul', 'ba-book-everything' ),
                'MAL' => __( 'Malanje', 'ba-book-everything' ),
                'MOX' => __( 'Moxico', 'ba-book-everything' ),
                'NAM' => __( 'Namibe', 'ba-book-everything' ),
                'UIG' => __( 'Uíge', 'ba-book-everything' ),
                'ZAI' => __( 'Zaire', 'ba-book-everything' ),
            ),
            'AR' => array( // Argentinian provinces.
                'C' => __( 'Ciudad Autónoma de Buenos Aires', 'ba-book-everything' ),
                'B' => __( 'Buenos Aires', 'ba-book-everything' ),
                'K' => __( 'Catamarca', 'ba-book-everything' ),
                'H' => __( 'Chaco', 'ba-book-everything' ),
                'U' => __( 'Chubut', 'ba-book-everything' ),
                'X' => __( 'Córdoba', 'ba-book-everything' ),
                'W' => __( 'Corrientes', 'ba-book-everything' ),
                'E' => __( 'Entre Ríos', 'ba-book-everything' ),
                'P' => __( 'Formosa', 'ba-book-everything' ),
                'Y' => __( 'Jujuy', 'ba-book-everything' ),
                'L' => __( 'La Pampa', 'ba-book-everything' ),
                'F' => __( 'La Rioja', 'ba-book-everything' ),
                'M' => __( 'Mendoza', 'ba-book-everything' ),
                'N' => __( 'Misiones', 'ba-book-everything' ),
                'Q' => __( 'Neuquén', 'ba-book-everything' ),
                'R' => __( 'Río Negro', 'ba-book-everything' ),
                'A' => __( 'Salta', 'ba-book-everything' ),
                'J' => __( 'San Juan', 'ba-book-everything' ),
                'D' => __( 'San Luis', 'ba-book-everything' ),
                'Z' => __( 'Santa Cruz', 'ba-book-everything' ),
                'S' => __( 'Santa Fe', 'ba-book-everything' ),
                'G' => __( 'Santiago del Estero', 'ba-book-everything' ),
                'V' => __( 'Tierra del Fuego', 'ba-book-everything' ),
                'T' => __( 'Tucumán', 'ba-book-everything' ),
            ),
            'AT' => array(),
            'AU' => array( // Australian states.
                'ACT' => __( 'Australian Capital Territory', 'ba-book-everything' ),
                'NSW' => __( 'New South Wales', 'ba-book-everything' ),
                'NT'  => __( 'Northern Territory', 'ba-book-everything' ),
                'QLD' => __( 'Queensland', 'ba-book-everything' ),
                'SA'  => __( 'South Australia', 'ba-book-everything' ),
                'TAS' => __( 'Tasmania', 'ba-book-everything' ),
                'VIC' => __( 'Victoria', 'ba-book-everything' ),
                'WA'  => __( 'Western Australia', 'ba-book-everything' ),
            ),
            'AX' => array(),
            'BD' => array( // Bangladeshi states (districts).
                'BD-05' => __( 'Bagerhat', 'ba-book-everything' ),
                'BD-01' => __( 'Bandarban', 'ba-book-everything' ),
                'BD-02' => __( 'Barguna', 'ba-book-everything' ),
                'BD-06' => __( 'Barishal', 'ba-book-everything' ),
                'BD-07' => __( 'Bhola', 'ba-book-everything' ),
                'BD-03' => __( 'Bogura', 'ba-book-everything' ),
                'BD-04' => __( 'Brahmanbaria', 'ba-book-everything' ),
                'BD-09' => __( 'Chandpur', 'ba-book-everything' ),
                'BD-10' => __( 'Chattogram', 'ba-book-everything' ),
                'BD-12' => __( 'Chuadanga', 'ba-book-everything' ),
                'BD-11' => __( "Cox's Bazar", 'ba-book-everything' ),
                'BD-08' => __( 'Cumilla', 'ba-book-everything' ),
                'BD-13' => __( 'Dhaka', 'ba-book-everything' ),
                'BD-14' => __( 'Dinajpur', 'ba-book-everything' ),
                'BD-15' => __( 'Faridpur ', 'ba-book-everything' ),
                'BD-16' => __( 'Feni', 'ba-book-everything' ),
                'BD-19' => __( 'Gaibandha', 'ba-book-everything' ),
                'BD-18' => __( 'Gazipur', 'ba-book-everything' ),
                'BD-17' => __( 'Gopalganj', 'ba-book-everything' ),
                'BD-20' => __( 'Habiganj', 'ba-book-everything' ),
                'BD-21' => __( 'Jamalpur', 'ba-book-everything' ),
                'BD-22' => __( 'Jashore', 'ba-book-everything' ),
                'BD-25' => __( 'Jhalokati', 'ba-book-everything' ),
                'BD-23' => __( 'Jhenaidah', 'ba-book-everything' ),
                'BD-24' => __( 'Joypurhat', 'ba-book-everything' ),
                'BD-29' => __( 'Khagrachhari', 'ba-book-everything' ),
                'BD-27' => __( 'Khulna', 'ba-book-everything' ),
                'BD-26' => __( 'Kishoreganj', 'ba-book-everything' ),
                'BD-28' => __( 'Kurigram', 'ba-book-everything' ),
                'BD-30' => __( 'Kushtia', 'ba-book-everything' ),
                'BD-31' => __( 'Lakshmipur', 'ba-book-everything' ),
                'BD-32' => __( 'Lalmonirhat', 'ba-book-everything' ),
                'BD-36' => __( 'Madaripur', 'ba-book-everything' ),
                'BD-37' => __( 'Magura', 'ba-book-everything' ),
                'BD-33' => __( 'Manikganj ', 'ba-book-everything' ),
                'BD-39' => __( 'Meherpur', 'ba-book-everything' ),
                'BD-38' => __( 'Moulvibazar', 'ba-book-everything' ),
                'BD-35' => __( 'Munshiganj', 'ba-book-everything' ),
                'BD-34' => __( 'Mymensingh', 'ba-book-everything' ),
                'BD-48' => __( 'Naogaon', 'ba-book-everything' ),
                'BD-43' => __( 'Narail', 'ba-book-everything' ),
                'BD-40' => __( 'Narayanganj', 'ba-book-everything' ),
                'BD-42' => __( 'Narsingdi', 'ba-book-everything' ),
                'BD-44' => __( 'Natore', 'ba-book-everything' ),
                'BD-45' => __( 'Nawabganj', 'ba-book-everything' ),
                'BD-41' => __( 'Netrakona', 'ba-book-everything' ),
                'BD-46' => __( 'Nilphamari', 'ba-book-everything' ),
                'BD-47' => __( 'Noakhali', 'ba-book-everything' ),
                'BD-49' => __( 'Pabna', 'ba-book-everything' ),
                'BD-52' => __( 'Panchagarh', 'ba-book-everything' ),
                'BD-51' => __( 'Patuakhali', 'ba-book-everything' ),
                'BD-50' => __( 'Pirojpur', 'ba-book-everything' ),
                'BD-53' => __( 'Rajbari', 'ba-book-everything' ),
                'BD-54' => __( 'Rajshahi', 'ba-book-everything' ),
                'BD-56' => __( 'Rangamati', 'ba-book-everything' ),
                'BD-55' => __( 'Rangpur', 'ba-book-everything' ),
                'BD-58' => __( 'Satkhira', 'ba-book-everything' ),
                'BD-62' => __( 'Shariatpur', 'ba-book-everything' ),
                'BD-57' => __( 'Sherpur', 'ba-book-everything' ),
                'BD-59' => __( 'Sirajganj', 'ba-book-everything' ),
                'BD-61' => __( 'Sunamganj', 'ba-book-everything' ),
                'BD-60' => __( 'Sylhet', 'ba-book-everything' ),
                'BD-63' => __( 'Tangail', 'ba-book-everything' ),
                'BD-64' => __( 'Thakurgaon', 'ba-book-everything' ),
            ),
            'BE' => array(),
            'BG' => array( // Bulgarian states.
                'BG-01' => __( 'Blagoevgrad', 'ba-book-everything' ),
                'BG-02' => __( 'Burgas', 'ba-book-everything' ),
                'BG-08' => __( 'Dobrich', 'ba-book-everything' ),
                'BG-07' => __( 'Gabrovo', 'ba-book-everything' ),
                'BG-26' => __( 'Haskovo', 'ba-book-everything' ),
                'BG-09' => __( 'Kardzhali', 'ba-book-everything' ),
                'BG-10' => __( 'Kyustendil', 'ba-book-everything' ),
                'BG-11' => __( 'Lovech', 'ba-book-everything' ),
                'BG-12' => __( 'Montana', 'ba-book-everything' ),
                'BG-13' => __( 'Pazardzhik', 'ba-book-everything' ),
                'BG-14' => __( 'Pernik', 'ba-book-everything' ),
                'BG-15' => __( 'Pleven', 'ba-book-everything' ),
                'BG-16' => __( 'Plovdiv', 'ba-book-everything' ),
                'BG-17' => __( 'Razgrad', 'ba-book-everything' ),
                'BG-18' => __( 'Ruse', 'ba-book-everything' ),
                'BG-27' => __( 'Shumen', 'ba-book-everything' ),
                'BG-19' => __( 'Silistra', 'ba-book-everything' ),
                'BG-20' => __( 'Sliven', 'ba-book-everything' ),
                'BG-21' => __( 'Smolyan', 'ba-book-everything' ),
                'BG-23' => __( 'Sofia', 'ba-book-everything' ),
                'BG-22' => __( 'Sofia-Grad', 'ba-book-everything' ),
                'BG-24' => __( 'Stara Zagora', 'ba-book-everything' ),
                'BG-25' => __( 'Targovishte', 'ba-book-everything' ),
                'BG-03' => __( 'Varna', 'ba-book-everything' ),
                'BG-04' => __( 'Veliko Tarnovo', 'ba-book-everything' ),
                'BG-05' => __( 'Vidin', 'ba-book-everything' ),
                'BG-06' => __( 'Vratsa', 'ba-book-everything' ),
                'BG-28' => __( 'Yambol', 'ba-book-everything' ),
            ),
            'BH' => array(),
            'BI' => array(),
            'BJ' => array( // Benin states.
                'AL' => __( 'Alibori', 'ba-book-everything' ),
                'AK' => __( 'Atakora', 'ba-book-everything' ),
                'AQ' => __( 'Atlantique', 'ba-book-everything' ),
                'BO' => __( 'Borgou', 'ba-book-everything' ),
                'CO' => __( 'Collines', 'ba-book-everything' ),
                'KO' => __( 'Kouffo', 'ba-book-everything' ),
                'DO' => __( 'Donga', 'ba-book-everything' ),
                'LI' => __( 'Littoral', 'ba-book-everything' ),
                'MO' => __( 'Mono', 'ba-book-everything' ),
                'OU' => __( 'Ouémé', 'ba-book-everything' ),
                'PL' => __( 'Plateau', 'ba-book-everything' ),
                'ZO' => __( 'Zou', 'ba-book-everything' ),
            ),
            'BO' => array( // Bolivian states.
                'B' => __( 'Chuquisaca', 'ba-book-everything' ),
                'H' => __( 'Beni', 'ba-book-everything' ),
                'C' => __( 'Cochabamba', 'ba-book-everything' ),
                'L' => __( 'La Paz', 'ba-book-everything' ),
                'O' => __( 'Oruro', 'ba-book-everything' ),
                'N' => __( 'Pando', 'ba-book-everything' ),
                'P' => __( 'Potosí', 'ba-book-everything' ),
                'S' => __( 'Santa Cruz', 'ba-book-everything' ),
                'T' => __( 'Tarija', 'ba-book-everything' ),
            ),
            'BR' => array( // Brazillian states.
                'AC' => __( 'Acre', 'ba-book-everything' ),
                'AL' => __( 'Alagoas', 'ba-book-everything' ),
                'AP' => __( 'Amapá', 'ba-book-everything' ),
                'AM' => __( 'Amazonas', 'ba-book-everything' ),
                'BA' => __( 'Bahia', 'ba-book-everything' ),
                'CE' => __( 'Ceará', 'ba-book-everything' ),
                'DF' => __( 'Distrito Federal', 'ba-book-everything' ),
                'ES' => __( 'Espírito Santo', 'ba-book-everything' ),
                'GO' => __( 'Goiás', 'ba-book-everything' ),
                'MA' => __( 'Maranhão', 'ba-book-everything' ),
                'MT' => __( 'Mato Grosso', 'ba-book-everything' ),
                'MS' => __( 'Mato Grosso do Sul', 'ba-book-everything' ),
                'MG' => __( 'Minas Gerais', 'ba-book-everything' ),
                'PA' => __( 'Pará', 'ba-book-everything' ),
                'PB' => __( 'Paraíba', 'ba-book-everything' ),
                'PR' => __( 'Paraná', 'ba-book-everything' ),
                'PE' => __( 'Pernambuco', 'ba-book-everything' ),
                'PI' => __( 'Piauí', 'ba-book-everything' ),
                'RJ' => __( 'Rio de Janeiro', 'ba-book-everything' ),
                'RN' => __( 'Rio Grande do Norte', 'ba-book-everything' ),
                'RS' => __( 'Rio Grande do Sul', 'ba-book-everything' ),
                'RO' => __( 'Rondônia', 'ba-book-everything' ),
                'RR' => __( 'Roraima', 'ba-book-everything' ),
                'SC' => __( 'Santa Catarina', 'ba-book-everything' ),
                'SP' => __( 'São Paulo', 'ba-book-everything' ),
                'SE' => __( 'Sergipe', 'ba-book-everything' ),
                'TO' => __( 'Tocantins', 'ba-book-everything' ),
            ),
            'CA' => array( // Canadian states.
                'AB' => __( 'Alberta', 'ba-book-everything' ),
                'BC' => __( 'British Columbia', 'ba-book-everything' ),
                'MB' => __( 'Manitoba', 'ba-book-everything' ),
                'NB' => __( 'New Brunswick', 'ba-book-everything' ),
                'NL' => __( 'Newfoundland and Labrador', 'ba-book-everything' ),
                'NT' => __( 'Northwest Territories', 'ba-book-everything' ),
                'NS' => __( 'Nova Scotia', 'ba-book-everything' ),
                'NU' => __( 'Nunavut', 'ba-book-everything' ),
                'ON' => __( 'Ontario', 'ba-book-everything' ),
                'PE' => __( 'Prince Edward Island', 'ba-book-everything' ),
                'QC' => __( 'Quebec', 'ba-book-everything' ),
                'SK' => __( 'Saskatchewan', 'ba-book-everything' ),
                'YT' => __( 'Yukon Territory', 'ba-book-everything' ),
            ),
            'CH' => array( // Cantons of Switzerland.
                'AG' => __( 'Aargau', 'ba-book-everything' ),
                'AR' => __( 'Appenzell Ausserrhoden', 'ba-book-everything' ),
                'AI' => __( 'Appenzell Innerrhoden', 'ba-book-everything' ),
                'BL' => __( 'Basel-Landschaft', 'ba-book-everything' ),
                'BS' => __( 'Basel-Stadt', 'ba-book-everything' ),
                'BE' => __( 'Bern', 'ba-book-everything' ),
                'FR' => __( 'Fribourg', 'ba-book-everything' ),
                'GE' => __( 'Geneva', 'ba-book-everything' ),
                'GL' => __( 'Glarus', 'ba-book-everything' ),
                'GR' => __( 'Graubünden', 'ba-book-everything' ),
                'JU' => __( 'Jura', 'ba-book-everything' ),
                'LU' => __( 'Luzern', 'ba-book-everything' ),
                'NE' => __( 'Neuchâtel', 'ba-book-everything' ),
                'NW' => __( 'Nidwalden', 'ba-book-everything' ),
                'OW' => __( 'Obwalden', 'ba-book-everything' ),
                'SH' => __( 'Schaffhausen', 'ba-book-everything' ),
                'SZ' => __( 'Schwyz', 'ba-book-everything' ),
                'SO' => __( 'Solothurn', 'ba-book-everything' ),
                'SG' => __( 'St. Gallen', 'ba-book-everything' ),
                'TG' => __( 'Thurgau', 'ba-book-everything' ),
                'TI' => __( 'Ticino', 'ba-book-everything' ),
                'UR' => __( 'Uri', 'ba-book-everything' ),
                'VS' => __( 'Valais', 'ba-book-everything' ),
                'VD' => __( 'Vaud', 'ba-book-everything' ),
                'ZG' => __( 'Zug', 'ba-book-everything' ),
                'ZH' => __( 'Zürich', 'ba-book-everything' ),
            ),
            'CN' => array( // Chinese states.
                'CN1'  => __( 'Yunnan / 云南', 'ba-book-everything' ),
                'CN2'  => __( 'Beijing / 北京', 'ba-book-everything' ),
                'CN3'  => __( 'Tianjin / 天津', 'ba-book-everything' ),
                'CN4'  => __( 'Hebei / 河北', 'ba-book-everything' ),
                'CN5'  => __( 'Shanxi / 山西', 'ba-book-everything' ),
                'CN6'  => __( 'Inner Mongolia / 內蒙古', 'ba-book-everything' ),
                'CN7'  => __( 'Liaoning / 辽宁', 'ba-book-everything' ),
                'CN8'  => __( 'Jilin / 吉林', 'ba-book-everything' ),
                'CN9'  => __( 'Heilongjiang / 黑龙江', 'ba-book-everything' ),
                'CN10' => __( 'Shanghai / 上海', 'ba-book-everything' ),
                'CN11' => __( 'Jiangsu / 江苏', 'ba-book-everything' ),
                'CN12' => __( 'Zhejiang / 浙江', 'ba-book-everything' ),
                'CN13' => __( 'Anhui / 安徽', 'ba-book-everything' ),
                'CN14' => __( 'Fujian / 福建', 'ba-book-everything' ),
                'CN15' => __( 'Jiangxi / 江西', 'ba-book-everything' ),
                'CN16' => __( 'Shandong / 山东', 'ba-book-everything' ),
                'CN17' => __( 'Henan / 河南', 'ba-book-everything' ),
                'CN18' => __( 'Hubei / 湖北', 'ba-book-everything' ),
                'CN19' => __( 'Hunan / 湖南', 'ba-book-everything' ),
                'CN20' => __( 'Guangdong / 广东', 'ba-book-everything' ),
                'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'ba-book-everything' ),
                'CN22' => __( 'Hainan / 海南', 'ba-book-everything' ),
                'CN23' => __( 'Chongqing / 重庆', 'ba-book-everything' ),
                'CN24' => __( 'Sichuan / 四川', 'ba-book-everything' ),
                'CN25' => __( 'Guizhou / 贵州', 'ba-book-everything' ),
                'CN26' => __( 'Shaanxi / 陕西', 'ba-book-everything' ),
                'CN27' => __( 'Gansu / 甘肃', 'ba-book-everything' ),
                'CN28' => __( 'Qinghai / 青海', 'ba-book-everything' ),
                'CN29' => __( 'Ningxia Hui / 宁夏', 'ba-book-everything' ),
                'CN30' => __( 'Macao / 澳门', 'ba-book-everything' ),
                'CN31' => __( 'Tibet / 西藏', 'ba-book-everything' ),
                'CN32' => __( 'Xinjiang / 新疆', 'ba-book-everything' ),
            ),
            'CZ' => array(),
            'DE' => array(),
            'DK' => array(),
            'DO' => array( // Dominican Republic.
                'DO-01' => __( 'Distrito Nacional', 'ba-book-everything' ),
                'DO-02' => __( 'Azua', 'ba-book-everything' ),
                'DO-03' => __( 'Baoruco', 'ba-book-everything' ),
                'DO-04' => __( 'Barahona', 'ba-book-everything' ),
                'DO-05' => __( 'Dajabón', 'ba-book-everything' ),
                'DO-06' => __( 'Duarte', 'ba-book-everything' ),
                'DO-07' => __( 'Elías Piña', 'ba-book-everything' ),
                'DO-08' => __( 'El Seibo', 'ba-book-everything' ),
                'DO-09' => __( 'Espaillat', 'ba-book-everything' ),
                'DO-10' => __( 'Independencia', 'ba-book-everything' ),
                'DO-11' => __( 'La Altagracia', 'ba-book-everything' ),
                'DO-12' => __( 'La Romana', 'ba-book-everything' ),
                'DO-13' => __( 'La Vega', 'ba-book-everything' ),
                'DO-14' => __( 'María Trinidad Sánchez', 'ba-book-everything' ),
                'DO-15' => __( 'Monte Cristi', 'ba-book-everything' ),
                'DO-16' => __( 'Pedernales', 'ba-book-everything' ),
                'DO-17' => __( 'Peravia', 'ba-book-everything' ),
                'DO-18' => __( 'Puerto Plata', 'ba-book-everything' ),
                'DO-19' => __( 'Hermanas Mirabal', 'ba-book-everything' ),
                'DO-20' => __( 'Samaná', 'ba-book-everything' ),
                'DO-21' => __( 'San Cristóbal', 'ba-book-everything' ),
                'DO-22' => __( 'San Juan', 'ba-book-everything' ),
                'DO-23' => __( 'San Pedro de Macorís', 'ba-book-everything' ),
                'DO-24' => __( 'Sánchez Ramírez', 'ba-book-everything' ),
                'DO-25' => __( 'Santiago', 'ba-book-everything' ),
                'DO-26' => __( 'Santiago Rodríguez', 'ba-book-everything' ),
                'DO-27' => __( 'Valverde', 'ba-book-everything' ),
                'DO-28' => __( 'Monseñor Nouel', 'ba-book-everything' ),
                'DO-29' => __( 'Monte Plata', 'ba-book-everything' ),
                'DO-30' => __( 'Hato Mayor', 'ba-book-everything' ),
                'DO-31' => __( 'San José de Ocoa', 'ba-book-everything' ),
                'DO-32' => __( 'Santo Domingo', 'ba-book-everything' ),
            ),
            'DZ' => array(
                'DZ-01' => __( 'Adrar', 'ba-book-everything' ),
                'DZ-02' => __( 'Chlef', 'ba-book-everything' ),
                'DZ-03' => __( 'Laghouat', 'ba-book-everything' ),
                'DZ-04' => __( 'Oum El Bouaghi', 'ba-book-everything' ),
                'DZ-05' => __( 'Batna', 'ba-book-everything' ),
                'DZ-06' => __( 'Béjaïa', 'ba-book-everything' ),
                'DZ-07' => __( 'Biskra', 'ba-book-everything' ),
                'DZ-08' => __( 'Béchar', 'ba-book-everything' ),
                'DZ-09' => __( 'Blida', 'ba-book-everything' ),
                'DZ-10' => __( 'Bouira', 'ba-book-everything' ),
                'DZ-11' => __( 'Tamanghasset', 'ba-book-everything' ),
                'DZ-12' => __( 'Tébessa', 'ba-book-everything' ),
                'DZ-13' => __( 'Tlemcen', 'ba-book-everything' ),
                'DZ-14' => __( 'Tiaret', 'ba-book-everything' ),
                'DZ-15' => __( 'Tizi Ouzou', 'ba-book-everything' ),
                'DZ-16' => __( 'Algiers', 'ba-book-everything' ),
                'DZ-17' => __( 'Djelfa', 'ba-book-everything' ),
                'DZ-18' => __( 'Jijel', 'ba-book-everything' ),
                'DZ-19' => __( 'Sétif', 'ba-book-everything' ),
                'DZ-20' => __( 'Saïda', 'ba-book-everything' ),
                'DZ-21' => __( 'Skikda', 'ba-book-everything' ),
                'DZ-22' => __( 'Sidi Bel Abbès', 'ba-book-everything' ),
                'DZ-23' => __( 'Annaba', 'ba-book-everything' ),
                'DZ-24' => __( 'Guelma', 'ba-book-everything' ),
                'DZ-25' => __( 'Constantine', 'ba-book-everything' ),
                'DZ-26' => __( 'Médéa', 'ba-book-everything' ),
                'DZ-27' => __( 'Mostaganem', 'ba-book-everything' ),
                'DZ-28' => __( 'M’Sila', 'ba-book-everything' ),
                'DZ-29' => __( 'Mascara', 'ba-book-everything' ),
                'DZ-30' => __( 'Ouargla', 'ba-book-everything' ),
                'DZ-31' => __( 'Oran', 'ba-book-everything' ),
                'DZ-32' => __( 'El Bayadh', 'ba-book-everything' ),
                'DZ-33' => __( 'Illizi', 'ba-book-everything' ),
                'DZ-34' => __( 'Bordj Bou Arréridj', 'ba-book-everything' ),
                'DZ-35' => __( 'Boumerdès', 'ba-book-everything' ),
                'DZ-36' => __( 'El Tarf', 'ba-book-everything' ),
                'DZ-37' => __( 'Tindouf', 'ba-book-everything' ),
                'DZ-38' => __( 'Tissemsilt', 'ba-book-everything' ),
                'DZ-39' => __( 'El Oued', 'ba-book-everything' ),
                'DZ-40' => __( 'Khenchela', 'ba-book-everything' ),
                'DZ-41' => __( 'Souk Ahras', 'ba-book-everything' ),
                'DZ-42' => __( 'Tipasa', 'ba-book-everything' ),
                'DZ-43' => __( 'Mila', 'ba-book-everything' ),
                'DZ-44' => __( 'Aïn Defla', 'ba-book-everything' ),
                'DZ-45' => __( 'Naama', 'ba-book-everything' ),
                'DZ-46' => __( 'Aïn Témouchent', 'ba-book-everything' ),
                'DZ-47' => __( 'Ghardaïa', 'ba-book-everything' ),
                'DZ-48' => __( 'Relizane', 'ba-book-everything' ),
            ),
            'EE' => array(),
            'EG' => array( // Egypt states.
                'EGALX' => __( 'Alexandria', 'ba-book-everything' ),
                'EGASN' => __( 'Aswan', 'ba-book-everything' ),
                'EGAST' => __( 'Asyut', 'ba-book-everything' ),
                'EGBA'  => __( 'Red Sea', 'ba-book-everything' ),
                'EGBH'  => __( 'Beheira', 'ba-book-everything' ),
                'EGBNS' => __( 'Beni Suef', 'ba-book-everything' ),
                'EGC'   => __( 'Cairo', 'ba-book-everything' ),
                'EGDK'  => __( 'Dakahlia', 'ba-book-everything' ),
                'EGDT'  => __( 'Damietta', 'ba-book-everything' ),
                'EGFYM' => __( 'Faiyum', 'ba-book-everything' ),
                'EGGH'  => __( 'Gharbia', 'ba-book-everything' ),
                'EGGZ'  => __( 'Giza', 'ba-book-everything' ),
                'EGIS'  => __( 'Ismailia', 'ba-book-everything' ),
                'EGJS'  => __( 'South Sinai', 'ba-book-everything' ),
                'EGKB'  => __( 'Qalyubia', 'ba-book-everything' ),
                'EGKFS' => __( 'Kafr el-Sheikh', 'ba-book-everything' ),
                'EGKN'  => __( 'Qena', 'ba-book-everything' ),
                'EGLX'  => __( 'Luxor', 'ba-book-everything' ),
                'EGMN'  => __( 'Minya', 'ba-book-everything' ),
                'EGMNF' => __( 'Monufia', 'ba-book-everything' ),
                'EGMT'  => __( 'Matrouh', 'ba-book-everything' ),
                'EGPTS' => __( 'Port Said', 'ba-book-everything' ),
                'EGSHG' => __( 'Sohag', 'ba-book-everything' ),
                'EGSHR' => __( 'Al Sharqia', 'ba-book-everything' ),
                'EGSIN' => __( 'North Sinai', 'ba-book-everything' ),
                'EGSUZ' => __( 'Suez', 'ba-book-everything' ),
                'EGWAD' => __( 'New Valley', 'ba-book-everything' ),
            ),
            'ES' => array( // Spanish states.
                'C'  => __( 'A Coruña', 'ba-book-everything' ),
                'VI' => __( 'Araba/Álava', 'ba-book-everything' ),
                'AB' => __( 'Albacete', 'ba-book-everything' ),
                'A'  => __( 'Alicante', 'ba-book-everything' ),
                'AL' => __( 'Almería', 'ba-book-everything' ),
                'O'  => __( 'Asturias', 'ba-book-everything' ),
                'AV' => __( 'Ávila', 'ba-book-everything' ),
                'BA' => __( 'Badajoz', 'ba-book-everything' ),
                'PM' => __( 'Baleares', 'ba-book-everything' ),
                'B'  => __( 'Barcelona', 'ba-book-everything' ),
                'BU' => __( 'Burgos', 'ba-book-everything' ),
                'CC' => __( 'Cáceres', 'ba-book-everything' ),
                'CA' => __( 'Cádiz', 'ba-book-everything' ),
                'S'  => __( 'Cantabria', 'ba-book-everything' ),
                'CS' => __( 'Castellón', 'ba-book-everything' ),
                'CE' => __( 'Ceuta', 'ba-book-everything' ),
                'CR' => __( 'Ciudad Real', 'ba-book-everything' ),
                'CO' => __( 'Córdoba', 'ba-book-everything' ),
                'CU' => __( 'Cuenca', 'ba-book-everything' ),
                'GI' => __( 'Girona', 'ba-book-everything' ),
                'GR' => __( 'Granada', 'ba-book-everything' ),
                'GU' => __( 'Guadalajara', 'ba-book-everything' ),
                'SS' => __( 'Gipuzkoa', 'ba-book-everything' ),
                'H'  => __( 'Huelva', 'ba-book-everything' ),
                'HU' => __( 'Huesca', 'ba-book-everything' ),
                'J'  => __( 'Jaén', 'ba-book-everything' ),
                'LO' => __( 'La Rioja', 'ba-book-everything' ),
                'GC' => __( 'Las Palmas', 'ba-book-everything' ),
                'LE' => __( 'León', 'ba-book-everything' ),
                'L'  => __( 'Lleida', 'ba-book-everything' ),
                'LU' => __( 'Lugo', 'ba-book-everything' ),
                'M'  => __( 'Madrid', 'ba-book-everything' ),
                'MA' => __( 'Málaga', 'ba-book-everything' ),
                'ML' => __( 'Melilla', 'ba-book-everything' ),
                'MU' => __( 'Murcia', 'ba-book-everything' ),
                'NA' => __( 'Navarra', 'ba-book-everything' ),
                'OR' => __( 'Ourense', 'ba-book-everything' ),
                'P'  => __( 'Palencia', 'ba-book-everything' ),
                'PO' => __( 'Pontevedra', 'ba-book-everything' ),
                'SA' => __( 'Salamanca', 'ba-book-everything' ),
                'TF' => __( 'Santa Cruz de Tenerife', 'ba-book-everything' ),
                'SG' => __( 'Segovia', 'ba-book-everything' ),
                'SE' => __( 'Sevilla', 'ba-book-everything' ),
                'SO' => __( 'Soria', 'ba-book-everything' ),
                'T'  => __( 'Tarragona', 'ba-book-everything' ),
                'TE' => __( 'Teruel', 'ba-book-everything' ),
                'TO' => __( 'Toledo', 'ba-book-everything' ),
                'V'  => __( 'Valencia', 'ba-book-everything' ),
                'VA' => __( 'Valladolid', 'ba-book-everything' ),
                'BI' => __( 'Biscay', 'ba-book-everything' ),
                'ZA' => __( 'Zamora', 'ba-book-everything' ),
                'Z'  => __( 'Zaragoza', 'ba-book-everything' ),
            ),
            'FI' => array(),
            'FR' => array(),
            'GH' => array( // Ghanaian Regions.
                'AF' => __( 'Ahafo', 'ba-book-everything' ),
                'AH' => __( 'Ashanti', 'ba-book-everything' ),
                'BA' => __( 'Brong-Ahafo', 'ba-book-everything' ),
                'BO' => __( 'Bono', 'ba-book-everything' ),
                'BE' => __( 'Bono East', 'ba-book-everything' ),
                'CP' => __( 'Central', 'ba-book-everything' ),
                'EP' => __( 'Eastern', 'ba-book-everything' ),
                'AA' => __( 'Greater Accra', 'ba-book-everything' ),
                'NE' => __( 'North East', 'ba-book-everything' ),
                'NP' => __( 'Northern', 'ba-book-everything' ),
                'OT' => __( 'Oti', 'ba-book-everything' ),
                'SV' => __( 'Savannah', 'ba-book-everything' ),
                'UE' => __( 'Upper East', 'ba-book-everything' ),
                'UW' => __( 'Upper West', 'ba-book-everything' ),
                'TV' => __( 'Volta', 'ba-book-everything' ),
                'WP' => __( 'Western', 'ba-book-everything' ),
                'WN' => __( 'Western North', 'ba-book-everything' ),
            ),
            'GP' => array(),
            'GR' => array( // Greek Regions.
                'I' => __( 'Attica', 'ba-book-everything' ),
                'A' => __( 'East Macedonia and Thrace', 'ba-book-everything' ),
                'B' => __( 'Central Macedonia', 'ba-book-everything' ),
                'C' => __( 'West Macedonia', 'ba-book-everything' ),
                'D' => __( 'Epirus', 'ba-book-everything' ),
                'E' => __( 'Thessaly', 'ba-book-everything' ),
                'F' => __( 'Ionian Islands', 'ba-book-everything' ),
                'G' => __( 'West Greece', 'ba-book-everything' ),
                'H' => __( 'Central Greece', 'ba-book-everything' ),
                'J' => __( 'Peloponnese', 'ba-book-everything' ),
                'K' => __( 'North Aegean', 'ba-book-everything' ),
                'L' => __( 'South Aegean', 'ba-book-everything' ),
                'M' => __( 'Crete', 'ba-book-everything' ),
            ),
            'GF' => array(),
            'HK' => array( // Hong Kong states.
                'HONG KONG'       => __( 'Hong Kong Island', 'ba-book-everything' ),
                'KOWLOON'         => __( 'Kowloon', 'ba-book-everything' ),
                'NEW TERRITORIES' => __( 'New Territories', 'ba-book-everything' ),
            ),
            'HU' => array( // Hungary states.
                'BK' => __( 'Bács-Kiskun', 'ba-book-everything' ),
                'BE' => __( 'Békés', 'ba-book-everything' ),
                'BA' => __( 'Baranya', 'ba-book-everything' ),
                'BZ' => __( 'Borsod-Abaúj-Zemplén', 'ba-book-everything' ),
                'BU' => __( 'Budapest', 'ba-book-everything' ),
                'CS' => __( 'Csongrád-Csanád', 'ba-book-everything' ),
                'FE' => __( 'Fejér', 'ba-book-everything' ),
                'GS' => __( 'Győr-Moson-Sopron', 'ba-book-everything' ),
                'HB' => __( 'Hajdú-Bihar', 'ba-book-everything' ),
                'HE' => __( 'Heves', 'ba-book-everything' ),
                'JN' => __( 'Jász-Nagykun-Szolnok', 'ba-book-everything' ),
                'KE' => __( 'Komárom-Esztergom', 'ba-book-everything' ),
                'NO' => __( 'Nógrád', 'ba-book-everything' ),
                'PE' => __( 'Pest', 'ba-book-everything' ),
                'SO' => __( 'Somogy', 'ba-book-everything' ),
                'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'ba-book-everything' ),
                'TO' => __( 'Tolna', 'ba-book-everything' ),
                'VA' => __( 'Vas', 'ba-book-everything' ),
                'VE' => __( 'Veszprém', 'ba-book-everything' ),
                'ZA' => __( 'Zala', 'ba-book-everything' ),
            ),
            'ID' => array( // Indonesia Provinces.
                'AC' => __( 'Daerah Istimewa Aceh', 'ba-book-everything' ),
                'SU' => __( 'Sumatera Utara', 'ba-book-everything' ),
                'SB' => __( 'Sumatera Barat', 'ba-book-everything' ),
                'RI' => __( 'Riau', 'ba-book-everything' ),
                'KR' => __( 'Kepulauan Riau', 'ba-book-everything' ),
                'JA' => __( 'Jambi', 'ba-book-everything' ),
                'SS' => __( 'Sumatera Selatan', 'ba-book-everything' ),
                'BB' => __( 'Bangka Belitung', 'ba-book-everything' ),
                'BE' => __( 'Bengkulu', 'ba-book-everything' ),
                'LA' => __( 'Lampung', 'ba-book-everything' ),
                'JK' => __( 'DKI Jakarta', 'ba-book-everything' ),
                'JB' => __( 'Jawa Barat', 'ba-book-everything' ),
                'BT' => __( 'Banten', 'ba-book-everything' ),
                'JT' => __( 'Jawa Tengah', 'ba-book-everything' ),
                'JI' => __( 'Jawa Timur', 'ba-book-everything' ),
                'YO' => __( 'Daerah Istimewa Yogyakarta', 'ba-book-everything' ),
                'BA' => __( 'Bali', 'ba-book-everything' ),
                'NB' => __( 'Nusa Tenggara Barat', 'ba-book-everything' ),
                'NT' => __( 'Nusa Tenggara Timur', 'ba-book-everything' ),
                'KB' => __( 'Kalimantan Barat', 'ba-book-everything' ),
                'KT' => __( 'Kalimantan Tengah', 'ba-book-everything' ),
                'KI' => __( 'Kalimantan Timur', 'ba-book-everything' ),
                'KS' => __( 'Kalimantan Selatan', 'ba-book-everything' ),
                'KU' => __( 'Kalimantan Utara', 'ba-book-everything' ),
                'SA' => __( 'Sulawesi Utara', 'ba-book-everything' ),
                'ST' => __( 'Sulawesi Tengah', 'ba-book-everything' ),
                'SG' => __( 'Sulawesi Tenggara', 'ba-book-everything' ),
                'SR' => __( 'Sulawesi Barat', 'ba-book-everything' ),
                'SN' => __( 'Sulawesi Selatan', 'ba-book-everything' ),
                'GO' => __( 'Gorontalo', 'ba-book-everything' ),
                'MA' => __( 'Maluku', 'ba-book-everything' ),
                'MU' => __( 'Maluku Utara', 'ba-book-everything' ),
                'PA' => __( 'Papua', 'ba-book-everything' ),
                'PB' => __( 'Papua Barat', 'ba-book-everything' ),
            ),
            'IE' => array( // Republic of Ireland.
                'CW' => __( 'Carlow', 'ba-book-everything' ),
                'CN' => __( 'Cavan', 'ba-book-everything' ),
                'CE' => __( 'Clare', 'ba-book-everything' ),
                'CO' => __( 'Cork', 'ba-book-everything' ),
                'DL' => __( 'Donegal', 'ba-book-everything' ),
                'D'  => __( 'Dublin', 'ba-book-everything' ),
                'G'  => __( 'Galway', 'ba-book-everything' ),
                'KY' => __( 'Kerry', 'ba-book-everything' ),
                'KE' => __( 'Kildare', 'ba-book-everything' ),
                'KK' => __( 'Kilkenny', 'ba-book-everything' ),
                'LS' => __( 'Laois', 'ba-book-everything' ),
                'LM' => __( 'Leitrim', 'ba-book-everything' ),
                'LK' => __( 'Limerick', 'ba-book-everything' ),
                'LD' => __( 'Longford', 'ba-book-everything' ),
                'LH' => __( 'Louth', 'ba-book-everything' ),
                'MO' => __( 'Mayo', 'ba-book-everything' ),
                'MH' => __( 'Meath', 'ba-book-everything' ),
                'MN' => __( 'Monaghan', 'ba-book-everything' ),
                'OY' => __( 'Offaly', 'ba-book-everything' ),
                'RN' => __( 'Roscommon', 'ba-book-everything' ),
                'SO' => __( 'Sligo', 'ba-book-everything' ),
                'TA' => __( 'Tipperary', 'ba-book-everything' ),
                'WD' => __( 'Waterford', 'ba-book-everything' ),
                'WH' => __( 'Westmeath', 'ba-book-everything' ),
                'WX' => __( 'Wexford', 'ba-book-everything' ),
                'WW' => __( 'Wicklow', 'ba-book-everything' ),
            ),
            'IN' => array( // Indian states.
                'AP' => __( 'Andhra Pradesh', 'ba-book-everything' ),
                'AR' => __( 'Arunachal Pradesh', 'ba-book-everything' ),
                'AS' => __( 'Assam', 'ba-book-everything' ),
                'BR' => __( 'Bihar', 'ba-book-everything' ),
                'CT' => __( 'Chhattisgarh', 'ba-book-everything' ),
                'GA' => __( 'Goa', 'ba-book-everything' ),
                'GJ' => __( 'Gujarat', 'ba-book-everything' ),
                'HR' => __( 'Haryana', 'ba-book-everything' ),
                'HP' => __( 'Himachal Pradesh', 'ba-book-everything' ),
                'JK' => __( 'Jammu and Kashmir', 'ba-book-everything' ),
                'JH' => __( 'Jharkhand', 'ba-book-everything' ),
                'KA' => __( 'Karnataka', 'ba-book-everything' ),
                'KL' => __( 'Kerala', 'ba-book-everything' ),
                'LA' => __( 'Ladakh', 'ba-book-everything' ),
                'MP' => __( 'Madhya Pradesh', 'ba-book-everything' ),
                'MH' => __( 'Maharashtra', 'ba-book-everything' ),
                'MN' => __( 'Manipur', 'ba-book-everything' ),
                'ML' => __( 'Meghalaya', 'ba-book-everything' ),
                'MZ' => __( 'Mizoram', 'ba-book-everything' ),
                'NL' => __( 'Nagaland', 'ba-book-everything' ),
                'OR' => __( 'Odisha', 'ba-book-everything' ),
                'PB' => __( 'Punjab', 'ba-book-everything' ),
                'RJ' => __( 'Rajasthan', 'ba-book-everything' ),
                'SK' => __( 'Sikkim', 'ba-book-everything' ),
                'TN' => __( 'Tamil Nadu', 'ba-book-everything' ),
                'TS' => __( 'Telangana', 'ba-book-everything' ),
                'TR' => __( 'Tripura', 'ba-book-everything' ),
                'UK' => __( 'Uttarakhand', 'ba-book-everything' ),
                'UP' => __( 'Uttar Pradesh', 'ba-book-everything' ),
                'WB' => __( 'West Bengal', 'ba-book-everything' ),
                'AN' => __( 'Andaman and Nicobar Islands', 'ba-book-everything' ),
                'CH' => __( 'Chandigarh', 'ba-book-everything' ),
                'DN' => __( 'Dadra and Nagar Haveli', 'ba-book-everything' ),
                'DD' => __( 'Daman and Diu', 'ba-book-everything' ),
                'DL' => __( 'Delhi', 'ba-book-everything' ),
                'LD' => __( 'Lakshadeep', 'ba-book-everything' ),
                'PY' => __( 'Pondicherry (Puducherry)', 'ba-book-everything' ),
            ),
            'IR' => array( // Iran States.
                'KHZ' => __( 'Khuzestan  (خوزستان)', 'ba-book-everything' ),
                'THR' => __( 'Tehran  (تهران)', 'ba-book-everything' ),
                'ILM' => __( 'Ilaam (ایلام)', 'ba-book-everything' ),
                'BHR' => __( 'Bushehr (بوشهر)', 'ba-book-everything' ),
                'ADL' => __( 'Ardabil (اردبیل)', 'ba-book-everything' ),
                'ESF' => __( 'Isfahan (اصفهان)', 'ba-book-everything' ),
                'YZD' => __( 'Yazd (یزد)', 'ba-book-everything' ),
                'KRH' => __( 'Kermanshah (کرمانشاه)', 'ba-book-everything' ),
                'KRN' => __( 'Kerman (کرمان)', 'ba-book-everything' ),
                'HDN' => __( 'Hamadan (همدان)', 'ba-book-everything' ),
                'GZN' => __( 'Ghazvin (قزوین)', 'ba-book-everything' ),
                'ZJN' => __( 'Zanjan (زنجان)', 'ba-book-everything' ),
                'LRS' => __( 'Luristan (لرستان)', 'ba-book-everything' ),
                'ABZ' => __( 'Alborz (البرز)', 'ba-book-everything' ),
                'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'ba-book-everything' ),
                'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'ba-book-everything' ),
                'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'ba-book-everything' ),
                'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'ba-book-everything' ),
                'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'ba-book-everything' ),
                'NKH' => __( 'North Khorasan (خراسان شمالی)', 'ba-book-everything' ),
                'SMN' => __( 'Semnan (سمنان)', 'ba-book-everything' ),
                'FRS' => __( 'Fars (فارس)', 'ba-book-everything' ),
                'QHM' => __( 'Qom (قم)', 'ba-book-everything' ),
                'KRD' => __( 'Kurdistan / کردستان)', 'ba-book-everything' ),
                'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'ba-book-everything' ),
                'GLS' => __( 'Golestan (گلستان)', 'ba-book-everything' ),
                'GIL' => __( 'Gilan (گیلان)', 'ba-book-everything' ),
                'MZN' => __( 'Mazandaran (مازندران)', 'ba-book-everything' ),
                'MKZ' => __( 'Markazi (مرکزی)', 'ba-book-everything' ),
                'HRZ' => __( 'Hormozgan (هرمزگان)', 'ba-book-everything' ),
                'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'ba-book-everything' ),
            ),
            'IS' => array(),
            'IT' => array( // Italy Provinces.
                'AG' => __( 'Agrigento', 'ba-book-everything' ),
                'AL' => __( 'Alessandria', 'ba-book-everything' ),
                'AN' => __( 'Ancona', 'ba-book-everything' ),
                'AO' => __( 'Aosta', 'ba-book-everything' ),
                'AR' => __( 'Arezzo', 'ba-book-everything' ),
                'AP' => __( 'Ascoli Piceno', 'ba-book-everything' ),
                'AT' => __( 'Asti', 'ba-book-everything' ),
                'AV' => __( 'Avellino', 'ba-book-everything' ),
                'BA' => __( 'Bari', 'ba-book-everything' ),
                'BT' => __( 'Barletta-Andria-Trani', 'ba-book-everything' ),
                'BL' => __( 'Belluno', 'ba-book-everything' ),
                'BN' => __( 'Benevento', 'ba-book-everything' ),
                'BG' => __( 'Bergamo', 'ba-book-everything' ),
                'BI' => __( 'Biella', 'ba-book-everything' ),
                'BO' => __( 'Bologna', 'ba-book-everything' ),
                'BZ' => __( 'Bolzano', 'ba-book-everything' ),
                'BS' => __( 'Brescia', 'ba-book-everything' ),
                'BR' => __( 'Brindisi', 'ba-book-everything' ),
                'CA' => __( 'Cagliari', 'ba-book-everything' ),
                'CL' => __( 'Caltanissetta', 'ba-book-everything' ),
                'CB' => __( 'Campobasso', 'ba-book-everything' ),
                'CE' => __( 'Caserta', 'ba-book-everything' ),
                'CT' => __( 'Catania', 'ba-book-everything' ),
                'CZ' => __( 'Catanzaro', 'ba-book-everything' ),
                'CH' => __( 'Chieti', 'ba-book-everything' ),
                'CO' => __( 'Como', 'ba-book-everything' ),
                'CS' => __( 'Cosenza', 'ba-book-everything' ),
                'CR' => __( 'Cremona', 'ba-book-everything' ),
                'KR' => __( 'Crotone', 'ba-book-everything' ),
                'CN' => __( 'Cuneo', 'ba-book-everything' ),
                'EN' => __( 'Enna', 'ba-book-everything' ),
                'FM' => __( 'Fermo', 'ba-book-everything' ),
                'FE' => __( 'Ferrara', 'ba-book-everything' ),
                'FI' => __( 'Firenze', 'ba-book-everything' ),
                'FG' => __( 'Foggia', 'ba-book-everything' ),
                'FC' => __( 'Forlì-Cesena', 'ba-book-everything' ),
                'FR' => __( 'Frosinone', 'ba-book-everything' ),
                'GE' => __( 'Genova', 'ba-book-everything' ),
                'GO' => __( 'Gorizia', 'ba-book-everything' ),
                'GR' => __( 'Grosseto', 'ba-book-everything' ),
                'IM' => __( 'Imperia', 'ba-book-everything' ),
                'IS' => __( 'Isernia', 'ba-book-everything' ),
                'SP' => __( 'La Spezia', 'ba-book-everything' ),
                'AQ' => __( "L'Aquila", 'ba-book-everything' ),
                'LT' => __( 'Latina', 'ba-book-everything' ),
                'LE' => __( 'Lecce', 'ba-book-everything' ),
                'LC' => __( 'Lecco', 'ba-book-everything' ),
                'LI' => __( 'Livorno', 'ba-book-everything' ),
                'LO' => __( 'Lodi', 'ba-book-everything' ),
                'LU' => __( 'Lucca', 'ba-book-everything' ),
                'MC' => __( 'Macerata', 'ba-book-everything' ),
                'MN' => __( 'Mantova', 'ba-book-everything' ),
                'MS' => __( 'Massa-Carrara', 'ba-book-everything' ),
                'MT' => __( 'Matera', 'ba-book-everything' ),
                'ME' => __( 'Messina', 'ba-book-everything' ),
                'MI' => __( 'Milano', 'ba-book-everything' ),
                'MO' => __( 'Modena', 'ba-book-everything' ),
                'MB' => __( 'Monza e della Brianza', 'ba-book-everything' ),
                'NA' => __( 'Napoli', 'ba-book-everything' ),
                'NO' => __( 'Novara', 'ba-book-everything' ),
                'NU' => __( 'Nuoro', 'ba-book-everything' ),
                'OR' => __( 'Oristano', 'ba-book-everything' ),
                'PD' => __( 'Padova', 'ba-book-everything' ),
                'PA' => __( 'Palermo', 'ba-book-everything' ),
                'PR' => __( 'Parma', 'ba-book-everything' ),
                'PV' => __( 'Pavia', 'ba-book-everything' ),
                'PG' => __( 'Perugia', 'ba-book-everything' ),
                'PU' => __( 'Pesaro e Urbino', 'ba-book-everything' ),
                'PE' => __( 'Pescara', 'ba-book-everything' ),
                'PC' => __( 'Piacenza', 'ba-book-everything' ),
                'PI' => __( 'Pisa', 'ba-book-everything' ),
                'PT' => __( 'Pistoia', 'ba-book-everything' ),
                'PN' => __( 'Pordenone', 'ba-book-everything' ),
                'PZ' => __( 'Potenza', 'ba-book-everything' ),
                'PO' => __( 'Prato', 'ba-book-everything' ),
                'RG' => __( 'Ragusa', 'ba-book-everything' ),
                'RA' => __( 'Ravenna', 'ba-book-everything' ),
                'RC' => __( 'Reggio Calabria', 'ba-book-everything' ),
                'RE' => __( 'Reggio Emilia', 'ba-book-everything' ),
                'RI' => __( 'Rieti', 'ba-book-everything' ),
                'RN' => __( 'Rimini', 'ba-book-everything' ),
                'RM' => __( 'Roma', 'ba-book-everything' ),
                'RO' => __( 'Rovigo', 'ba-book-everything' ),
                'SA' => __( 'Salerno', 'ba-book-everything' ),
                'SS' => __( 'Sassari', 'ba-book-everything' ),
                'SV' => __( 'Savona', 'ba-book-everything' ),
                'SI' => __( 'Siena', 'ba-book-everything' ),
                'SR' => __( 'Siracusa', 'ba-book-everything' ),
                'SO' => __( 'Sondrio', 'ba-book-everything' ),
                'SU' => __( 'Sud Sardegna', 'ba-book-everything' ),
                'TA' => __( 'Taranto', 'ba-book-everything' ),
                'TE' => __( 'Teramo', 'ba-book-everything' ),
                'TR' => __( 'Terni', 'ba-book-everything' ),
                'TO' => __( 'Torino', 'ba-book-everything' ),
                'TP' => __( 'Trapani', 'ba-book-everything' ),
                'TN' => __( 'Trento', 'ba-book-everything' ),
                'TV' => __( 'Treviso', 'ba-book-everything' ),
                'TS' => __( 'Trieste', 'ba-book-everything' ),
                'UD' => __( 'Udine', 'ba-book-everything' ),
                'VA' => __( 'Varese', 'ba-book-everything' ),
                'VE' => __( 'Venezia', 'ba-book-everything' ),
                'VB' => __( 'Verbano-Cusio-Ossola', 'ba-book-everything' ),
                'VC' => __( 'Vercelli', 'ba-book-everything' ),
                'VR' => __( 'Verona', 'ba-book-everything' ),
                'VV' => __( 'Vibo Valentia', 'ba-book-everything' ),
                'VI' => __( 'Vicenza', 'ba-book-everything' ),
                'VT' => __( 'Viterbo', 'ba-book-everything' ),
            ),
            'IL' => array(),
            'IM' => array(),
            'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
                'JM-01' => __( 'Kingston', 'ba-book-everything' ),
                'JM-02' => __( 'Saint Andrew', 'ba-book-everything' ),
                'JM-03' => __( 'Saint Thomas', 'ba-book-everything' ),
                'JM-04' => __( 'Portland', 'ba-book-everything' ),
                'JM-05' => __( 'Saint Mary', 'ba-book-everything' ),
                'JM-06' => __( 'Saint Ann', 'ba-book-everything' ),
                'JM-07' => __( 'Trelawny', 'ba-book-everything' ),
                'JM-08' => __( 'Saint James', 'ba-book-everything' ),
                'JM-09' => __( 'Hanover', 'ba-book-everything' ),
                'JM-10' => __( 'Westmoreland', 'ba-book-everything' ),
                'JM-11' => __( 'Saint Elizabeth', 'ba-book-everything' ),
                'JM-12' => __( 'Manchester', 'ba-book-everything' ),
                'JM-13' => __( 'Clarendon', 'ba-book-everything' ),
                'JM-14' => __( 'Saint Catherine', 'ba-book-everything' ),
            ),

            /**
             * Japan States.
             *
             * English notation of prefectures conform to the notation of Japan Post.
             * The suffix corresponds with the Japanese translation file.
             */
            'JP' => array(
                'JP01' => __( 'Hokkaido', 'ba-book-everything' ),
                'JP02' => __( 'Aomori', 'ba-book-everything' ),
                'JP03' => __( 'Iwate', 'ba-book-everything' ),
                'JP04' => __( 'Miyagi', 'ba-book-everything' ),
                'JP05' => __( 'Akita', 'ba-book-everything' ),
                'JP06' => __( 'Yamagata', 'ba-book-everything' ),
                'JP07' => __( 'Fukushima', 'ba-book-everything' ),
                'JP08' => __( 'Ibaraki', 'ba-book-everything' ),
                'JP09' => __( 'Tochigi', 'ba-book-everything' ),
                'JP10' => __( 'Gunma', 'ba-book-everything' ),
                'JP11' => __( 'Saitama', 'ba-book-everything' ),
                'JP12' => __( 'Chiba', 'ba-book-everything' ),
                'JP13' => __( 'Tokyo', 'ba-book-everything' ),
                'JP14' => __( 'Kanagawa', 'ba-book-everything' ),
                'JP15' => __( 'Niigata', 'ba-book-everything' ),
                'JP16' => __( 'Toyama', 'ba-book-everything' ),
                'JP17' => __( 'Ishikawa', 'ba-book-everything' ),
                'JP18' => __( 'Fukui', 'ba-book-everything' ),
                'JP19' => __( 'Yamanashi', 'ba-book-everything' ),
                'JP20' => __( 'Nagano', 'ba-book-everything' ),
                'JP21' => __( 'Gifu', 'ba-book-everything' ),
                'JP22' => __( 'Shizuoka', 'ba-book-everything' ),
                'JP23' => __( 'Aichi', 'ba-book-everything' ),
                'JP24' => __( 'Mie', 'ba-book-everything' ),
                'JP25' => __( 'Shiga', 'ba-book-everything' ),
                'JP26' => __( 'Kyoto', 'ba-book-everything' ),
                'JP27' => __( 'Osaka', 'ba-book-everything' ),
                'JP28' => __( 'Hyogo', 'ba-book-everything' ),
                'JP29' => __( 'Nara', 'ba-book-everything' ),
                'JP30' => __( 'Wakayama', 'ba-book-everything' ),
                'JP31' => __( 'Tottori', 'ba-book-everything' ),
                'JP32' => __( 'Shimane', 'ba-book-everything' ),
                'JP33' => __( 'Okayama', 'ba-book-everything' ),
                'JP34' => __( 'Hiroshima', 'ba-book-everything' ),
                'JP35' => __( 'Yamaguchi', 'ba-book-everything' ),
                'JP36' => __( 'Tokushima', 'ba-book-everything' ),
                'JP37' => __( 'Kagawa', 'ba-book-everything' ),
                'JP38' => __( 'Ehime', 'ba-book-everything' ),
                'JP39' => __( 'Kochi', 'ba-book-everything' ),
                'JP40' => __( 'Fukuoka', 'ba-book-everything' ),
                'JP41' => __( 'Saga', 'ba-book-everything' ),
                'JP42' => __( 'Nagasaki', 'ba-book-everything' ),
                'JP43' => __( 'Kumamoto', 'ba-book-everything' ),
                'JP44' => __( 'Oita', 'ba-book-everything' ),
                'JP45' => __( 'Miyazaki', 'ba-book-everything' ),
                'JP46' => __( 'Kagoshima', 'ba-book-everything' ),
                'JP47' => __( 'Okinawa', 'ba-book-everything' ),
            ),
            'KE' => array( // Kenya counties.
                'KE01' => __( 'Baringo', 'ba-book-everything' ),
                'KE02' => __( 'Bomet', 'ba-book-everything' ),
                'KE03' => __( 'Bungoma', 'ba-book-everything' ),
                'KE04' => __( 'Busia', 'ba-book-everything' ),
                'KE05' => __( 'Elgeyo-Marakwet', 'ba-book-everything' ),
                'KE06' => __( 'Embu', 'ba-book-everything' ),
                'KE07' => __( 'Garissa', 'ba-book-everything' ),
                'KE08' => __( 'Homa Bay', 'ba-book-everything' ),
                'KE09' => __( 'Isiolo', 'ba-book-everything' ),
                'KE10' => __( 'Kajiado', 'ba-book-everything' ),
                'KE11' => __( 'Kakamega', 'ba-book-everything' ),
                'KE12' => __( 'Kericho', 'ba-book-everything' ),
                'KE13' => __( 'Kiambu', 'ba-book-everything' ),
                'KE14' => __( 'Kilifi', 'ba-book-everything' ),
                'KE15' => __( 'Kirinyaga', 'ba-book-everything' ),
                'KE16' => __( 'Kisii', 'ba-book-everything' ),
                'KE17' => __( 'Kisumu', 'ba-book-everything' ),
                'KE18' => __( 'Kitui', 'ba-book-everything' ),
                'KE19' => __( 'Kwale', 'ba-book-everything' ),
                'KE20' => __( 'Laikipia', 'ba-book-everything' ),
                'KE21' => __( 'Lamu', 'ba-book-everything' ),
                'KE22' => __( 'Machakos', 'ba-book-everything' ),
                'KE23' => __( 'Makueni', 'ba-book-everything' ),
                'KE24' => __( 'Mandera', 'ba-book-everything' ),
                'KE25' => __( 'Marsabit', 'ba-book-everything' ),
                'KE26' => __( 'Meru', 'ba-book-everything' ),
                'KE27' => __( 'Migori', 'ba-book-everything' ),
                'KE28' => __( 'Mombasa', 'ba-book-everything' ),
                'KE29' => __( 'Murang’a', 'ba-book-everything' ),
                'KE30' => __( 'Nairobi County', 'ba-book-everything' ),
                'KE31' => __( 'Nakuru', 'ba-book-everything' ),
                'KE32' => __( 'Nandi', 'ba-book-everything' ),
                'KE33' => __( 'Narok', 'ba-book-everything' ),
                'KE34' => __( 'Nyamira', 'ba-book-everything' ),
                'KE35' => __( 'Nyandarua', 'ba-book-everything' ),
                'KE36' => __( 'Nyeri', 'ba-book-everything' ),
                'KE37' => __( 'Samburu', 'ba-book-everything' ),
                'KE38' => __( 'Siaya', 'ba-book-everything' ),
                'KE39' => __( 'Taita-Taveta', 'ba-book-everything' ),
                'KE40' => __( 'Tana River', 'ba-book-everything' ),
                'KE41' => __( 'Tharaka-Nithi', 'ba-book-everything' ),
                'KE42' => __( 'Trans Nzoia', 'ba-book-everything' ),
                'KE43' => __( 'Turkana', 'ba-book-everything' ),
                'KE44' => __( 'Uasin Gishu', 'ba-book-everything' ),
                'KE45' => __( 'Vihiga', 'ba-book-everything' ),
                'KE46' => __( 'Wajir', 'ba-book-everything' ),
                'KE47' => __( 'West Pokot', 'ba-book-everything' ),
            ),
            'KR' => array(),
            'KW' => array(),
            'LA' => array(
                'AT' => __( 'Attapeu', 'ba-book-everything' ),
                'BK' => __( 'Bokeo', 'ba-book-everything' ),
                'BL' => __( 'Bolikhamsai', 'ba-book-everything' ),
                'CH' => __( 'Champasak', 'ba-book-everything' ),
                'HO' => __( 'Houaphanh', 'ba-book-everything' ),
                'KH' => __( 'Khammouane', 'ba-book-everything' ),
                'LM' => __( 'Luang Namtha', 'ba-book-everything' ),
                'LP' => __( 'Luang Prabang', 'ba-book-everything' ),
                'OU' => __( 'Oudomxay', 'ba-book-everything' ),
                'PH' => __( 'Phongsaly', 'ba-book-everything' ),
                'SL' => __( 'Salavan', 'ba-book-everything' ),
                'SV' => __( 'Savannakhet', 'ba-book-everything' ),
                'VI' => __( 'Vientiane Province', 'ba-book-everything' ),
                'VT' => __( 'Vientiane', 'ba-book-everything' ),
                'XA' => __( 'Sainyabuli', 'ba-book-everything' ),
                'XE' => __( 'Sekong', 'ba-book-everything' ),
                'XI' => __( 'Xiangkhouang', 'ba-book-everything' ),
                'XS' => __( 'Xaisomboun', 'ba-book-everything' ),
            ),
            'LB' => array(),
            'LR' => array( // Liberia provinces.
                'BM' => __( 'Bomi', 'ba-book-everything' ),
                'BN' => __( 'Bong', 'ba-book-everything' ),
                'GA' => __( 'Gbarpolu', 'ba-book-everything' ),
                'GB' => __( 'Grand Bassa', 'ba-book-everything' ),
                'GC' => __( 'Grand Cape Mount', 'ba-book-everything' ),
                'GG' => __( 'Grand Gedeh', 'ba-book-everything' ),
                'GK' => __( 'Grand Kru', 'ba-book-everything' ),
                'LO' => __( 'Lofa', 'ba-book-everything' ),
                'MA' => __( 'Margibi', 'ba-book-everything' ),
                'MY' => __( 'Maryland', 'ba-book-everything' ),
                'MO' => __( 'Montserrado', 'ba-book-everything' ),
                'NM' => __( 'Nimba', 'ba-book-everything' ),
                'RV' => __( 'Rivercess', 'ba-book-everything' ),
                'RG' => __( 'River Gee', 'ba-book-everything' ),
                'SN' => __( 'Sinoe', 'ba-book-everything' ),
            ),
            'LU' => array(),
            'MD' => array( // Moldova states.
                'C'  => __( 'Chișinău', 'ba-book-everything' ),
                'BL' => __( 'Bălți', 'ba-book-everything' ),
                'AN' => __( 'Anenii Noi', 'ba-book-everything' ),
                'BS' => __( 'Basarabeasca', 'ba-book-everything' ),
                'BR' => __( 'Briceni', 'ba-book-everything' ),
                'CH' => __( 'Cahul', 'ba-book-everything' ),
                'CT' => __( 'Cantemir', 'ba-book-everything' ),
                'CL' => __( 'Călărași', 'ba-book-everything' ),
                'CS' => __( 'Căușeni', 'ba-book-everything' ),
                'CM' => __( 'Cimișlia', 'ba-book-everything' ),
                'CR' => __( 'Criuleni', 'ba-book-everything' ),
                'DN' => __( 'Dondușeni', 'ba-book-everything' ),
                'DR' => __( 'Drochia', 'ba-book-everything' ),
                'DB' => __( 'Dubăsari', 'ba-book-everything' ),
                'ED' => __( 'Edineț', 'ba-book-everything' ),
                'FL' => __( 'Fălești', 'ba-book-everything' ),
                'FR' => __( 'Florești', 'ba-book-everything' ),
                'GE' => __( 'UTA Găgăuzia', 'ba-book-everything' ),
                'GL' => __( 'Glodeni', 'ba-book-everything' ),
                'HN' => __( 'Hîncești', 'ba-book-everything' ),
                'IL' => __( 'Ialoveni', 'ba-book-everything' ),
                'LV' => __( 'Leova', 'ba-book-everything' ),
                'NS' => __( 'Nisporeni', 'ba-book-everything' ),
                'OC' => __( 'Ocnița', 'ba-book-everything' ),
                'OR' => __( 'Orhei', 'ba-book-everything' ),
                'RZ' => __( 'Rezina', 'ba-book-everything' ),
                'RS' => __( 'Rîșcani', 'ba-book-everything' ),
                'SG' => __( 'Sîngerei', 'ba-book-everything' ),
                'SR' => __( 'Soroca', 'ba-book-everything' ),
                'ST' => __( 'Strășeni', 'ba-book-everything' ),
                'SD' => __( 'Șoldănești', 'ba-book-everything' ),
                'SV' => __( 'Ștefan Vodă', 'ba-book-everything' ),
                'TR' => __( 'Taraclia', 'ba-book-everything' ),
                'TL' => __( 'Telenești', 'ba-book-everything' ),
                'UN' => __( 'Ungheni', 'ba-book-everything' ),
            ),
            'MQ' => array(),
            'MT' => array(),
            'MX' => array( // Mexico States.
                'DF' => __( 'Ciudad de México', 'ba-book-everything' ),
                'JA' => __( 'Jalisco', 'ba-book-everything' ),
                'NL' => __( 'Nuevo León', 'ba-book-everything' ),
                'AG' => __( 'Aguascalientes', 'ba-book-everything' ),
                'BC' => __( 'Baja California', 'ba-book-everything' ),
                'BS' => __( 'Baja California Sur', 'ba-book-everything' ),
                'CM' => __( 'Campeche', 'ba-book-everything' ),
                'CS' => __( 'Chiapas', 'ba-book-everything' ),
                'CH' => __( 'Chihuahua', 'ba-book-everything' ),
                'CO' => __( 'Coahuila', 'ba-book-everything' ),
                'CL' => __( 'Colima', 'ba-book-everything' ),
                'DG' => __( 'Durango', 'ba-book-everything' ),
                'GT' => __( 'Guanajuato', 'ba-book-everything' ),
                'GR' => __( 'Guerrero', 'ba-book-everything' ),
                'HG' => __( 'Hidalgo', 'ba-book-everything' ),
                'MX' => __( 'Estado de México', 'ba-book-everything' ),
                'MI' => __( 'Michoacán', 'ba-book-everything' ),
                'MO' => __( 'Morelos', 'ba-book-everything' ),
                'NA' => __( 'Nayarit', 'ba-book-everything' ),
                'OA' => __( 'Oaxaca', 'ba-book-everything' ),
                'PU' => __( 'Puebla', 'ba-book-everything' ),
                'QT' => __( 'Querétaro', 'ba-book-everything' ),
                'QR' => __( 'Quintana Roo', 'ba-book-everything' ),
                'SL' => __( 'San Luis Potosí', 'ba-book-everything' ),
                'SI' => __( 'Sinaloa', 'ba-book-everything' ),
                'SO' => __( 'Sonora', 'ba-book-everything' ),
                'TB' => __( 'Tabasco', 'ba-book-everything' ),
                'TM' => __( 'Tamaulipas', 'ba-book-everything' ),
                'TL' => __( 'Tlaxcala', 'ba-book-everything' ),
                'VE' => __( 'Veracruz', 'ba-book-everything' ),
                'YU' => __( 'Yucatán', 'ba-book-everything' ),
                'ZA' => __( 'Zacatecas', 'ba-book-everything' ),
            ),
            'MY' => array( // Malaysian states.
                'JHR' => __( 'Johor', 'ba-book-everything' ),
                'KDH' => __( 'Kedah', 'ba-book-everything' ),
                'KTN' => __( 'Kelantan', 'ba-book-everything' ),
                'LBN' => __( 'Labuan', 'ba-book-everything' ),
                'MLK' => __( 'Malacca (Melaka)', 'ba-book-everything' ),
                'NSN' => __( 'Negeri Sembilan', 'ba-book-everything' ),
                'PHG' => __( 'Pahang', 'ba-book-everything' ),
                'PNG' => __( 'Penang (Pulau Pinang)', 'ba-book-everything' ),
                'PRK' => __( 'Perak', 'ba-book-everything' ),
                'PLS' => __( 'Perlis', 'ba-book-everything' ),
                'SBH' => __( 'Sabah', 'ba-book-everything' ),
                'SWK' => __( 'Sarawak', 'ba-book-everything' ),
                'SGR' => __( 'Selangor', 'ba-book-everything' ),
                'TRG' => __( 'Terengganu', 'ba-book-everything' ),
                'PJY' => __( 'Putrajaya', 'ba-book-everything' ),
                'KUL' => __( 'Kuala Lumpur', 'ba-book-everything' ),
            ),
            'MZ' => array( // Mozambique provinces.
                'MZP'   => __( 'Cabo Delgado', 'ba-book-everything' ),
                'MZG'   => __( 'Gaza', 'ba-book-everything' ),
                'MZI'   => __( 'Inhambane', 'ba-book-everything' ),
                'MZB'   => __( 'Manica', 'ba-book-everything' ),
                'MZL'   => __( 'Maputo Province', 'ba-book-everything' ),
                'MZMPM' => __( 'Maputo', 'ba-book-everything' ),
                'MZN'   => __( 'Nampula', 'ba-book-everything' ),
                'MZA'   => __( 'Niassa', 'ba-book-everything' ),
                'MZS'   => __( 'Sofala', 'ba-book-everything' ),
                'MZT'   => __( 'Tete', 'ba-book-everything' ),
                'MZQ'   => __( 'Zambézia', 'ba-book-everything' ),
            ),
            'NA' => array( // Namibia regions.
                'ER' => __( 'Erongo', 'ba-book-everything' ),
                'HA' => __( 'Hardap', 'ba-book-everything' ),
                'KA' => __( 'Karas', 'ba-book-everything' ),
                'KE' => __( 'Kavango East', 'ba-book-everything' ),
                'KW' => __( 'Kavango West', 'ba-book-everything' ),
                'KH' => __( 'Khomas', 'ba-book-everything' ),
                'KU' => __( 'Kunene', 'ba-book-everything' ),
                'OW' => __( 'Ohangwena', 'ba-book-everything' ),
                'OH' => __( 'Omaheke', 'ba-book-everything' ),
                'OS' => __( 'Omusati', 'ba-book-everything' ),
                'ON' => __( 'Oshana', 'ba-book-everything' ),
                'OT' => __( 'Oshikoto', 'ba-book-everything' ),
                'OD' => __( 'Otjozondjupa', 'ba-book-everything' ),
                'CA' => __( 'Zambezi', 'ba-book-everything' ),
            ),
            'NG' => array( // Nigerian provinces.
                'AB' => __( 'Abia', 'ba-book-everything' ),
                'FC' => __( 'Abuja', 'ba-book-everything' ),
                'AD' => __( 'Adamawa', 'ba-book-everything' ),
                'AK' => __( 'Akwa Ibom', 'ba-book-everything' ),
                'AN' => __( 'Anambra', 'ba-book-everything' ),
                'BA' => __( 'Bauchi', 'ba-book-everything' ),
                'BY' => __( 'Bayelsa', 'ba-book-everything' ),
                'BE' => __( 'Benue', 'ba-book-everything' ),
                'BO' => __( 'Borno', 'ba-book-everything' ),
                'CR' => __( 'Cross River', 'ba-book-everything' ),
                'DE' => __( 'Delta', 'ba-book-everything' ),
                'EB' => __( 'Ebonyi', 'ba-book-everything' ),
                'ED' => __( 'Edo', 'ba-book-everything' ),
                'EK' => __( 'Ekiti', 'ba-book-everything' ),
                'EN' => __( 'Enugu', 'ba-book-everything' ),
                'GO' => __( 'Gombe', 'ba-book-everything' ),
                'IM' => __( 'Imo', 'ba-book-everything' ),
                'JI' => __( 'Jigawa', 'ba-book-everything' ),
                'KD' => __( 'Kaduna', 'ba-book-everything' ),
                'KN' => __( 'Kano', 'ba-book-everything' ),
                'KT' => __( 'Katsina', 'ba-book-everything' ),
                'KE' => __( 'Kebbi', 'ba-book-everything' ),
                'KO' => __( 'Kogi', 'ba-book-everything' ),
                'KW' => __( 'Kwara', 'ba-book-everything' ),
                'LA' => __( 'Lagos', 'ba-book-everything' ),
                'NA' => __( 'Nasarawa', 'ba-book-everything' ),
                'NI' => __( 'Niger', 'ba-book-everything' ),
                'OG' => __( 'Ogun', 'ba-book-everything' ),
                'ON' => __( 'Ondo', 'ba-book-everything' ),
                'OS' => __( 'Osun', 'ba-book-everything' ),
                'OY' => __( 'Oyo', 'ba-book-everything' ),
                'PL' => __( 'Plateau', 'ba-book-everything' ),
                'RI' => __( 'Rivers', 'ba-book-everything' ),
                'SO' => __( 'Sokoto', 'ba-book-everything' ),
                'TA' => __( 'Taraba', 'ba-book-everything' ),
                'YO' => __( 'Yobe', 'ba-book-everything' ),
                'ZA' => __( 'Zamfara', 'ba-book-everything' ),
            ),
            'NL' => array(),
            'NO' => array(),
            'NP' => array( // Nepal states (Zones).
                'BAG' => __( 'Bagmati', 'ba-book-everything' ),
                'BHE' => __( 'Bheri', 'ba-book-everything' ),
                'DHA' => __( 'Dhaulagiri', 'ba-book-everything' ),
                'GAN' => __( 'Gandaki', 'ba-book-everything' ),
                'JAN' => __( 'Janakpur', 'ba-book-everything' ),
                'KAR' => __( 'Karnali', 'ba-book-everything' ),
                'KOS' => __( 'Koshi', 'ba-book-everything' ),
                'LUM' => __( 'Lumbini', 'ba-book-everything' ),
                'MAH' => __( 'Mahakali', 'ba-book-everything' ),
                'MEC' => __( 'Mechi', 'ba-book-everything' ),
                'NAR' => __( 'Narayani', 'ba-book-everything' ),
                'RAP' => __( 'Rapti', 'ba-book-everything' ),
                'SAG' => __( 'Sagarmatha', 'ba-book-everything' ),
                'SET' => __( 'Seti', 'ba-book-everything' ),
            ),
            'NZ' => array( // New Zealand States.
                'NL' => __( 'Northland', 'ba-book-everything' ),
                'AK' => __( 'Auckland', 'ba-book-everything' ),
                'WA' => __( 'Waikato', 'ba-book-everything' ),
                'BP' => __( 'Bay of Plenty', 'ba-book-everything' ),
                'TK' => __( 'Taranaki', 'ba-book-everything' ),
                'GI' => __( 'Gisborne', 'ba-book-everything' ),
                'HB' => __( 'Hawke’s Bay', 'ba-book-everything' ),
                'MW' => __( 'Manawatu-Wanganui', 'ba-book-everything' ),
                'WE' => __( 'Wellington', 'ba-book-everything' ),
                'NS' => __( 'Nelson', 'ba-book-everything' ),
                'MB' => __( 'Marlborough', 'ba-book-everything' ),
                'TM' => __( 'Tasman', 'ba-book-everything' ),
                'WC' => __( 'West Coast', 'ba-book-everything' ),
                'CT' => __( 'Canterbury', 'ba-book-everything' ),
                'OT' => __( 'Otago', 'ba-book-everything' ),
                'SL' => __( 'Southland', 'ba-book-everything' ),
            ),
            'PE' => array( // Peru states.
                'CAL' => __( 'El Callao', 'ba-book-everything' ),
                'LMA' => __( 'Municipalidad Metropolitana de Lima', 'ba-book-everything' ),
                'AMA' => __( 'Amazonas', 'ba-book-everything' ),
                'ANC' => __( 'Ancash', 'ba-book-everything' ),
                'APU' => __( 'Apurímac', 'ba-book-everything' ),
                'ARE' => __( 'Arequipa', 'ba-book-everything' ),
                'AYA' => __( 'Ayacucho', 'ba-book-everything' ),
                'CAJ' => __( 'Cajamarca', 'ba-book-everything' ),
                'CUS' => __( 'Cusco', 'ba-book-everything' ),
                'HUV' => __( 'Huancavelica', 'ba-book-everything' ),
                'HUC' => __( 'Huánuco', 'ba-book-everything' ),
                'ICA' => __( 'Ica', 'ba-book-everything' ),
                'JUN' => __( 'Junín', 'ba-book-everything' ),
                'LAL' => __( 'La Libertad', 'ba-book-everything' ),
                'LAM' => __( 'Lambayeque', 'ba-book-everything' ),
                'LIM' => __( 'Lima', 'ba-book-everything' ),
                'LOR' => __( 'Loreto', 'ba-book-everything' ),
                'MDD' => __( 'Madre de Dios', 'ba-book-everything' ),
                'MOQ' => __( 'Moquegua', 'ba-book-everything' ),
                'PAS' => __( 'Pasco', 'ba-book-everything' ),
                'PIU' => __( 'Piura', 'ba-book-everything' ),
                'PUN' => __( 'Puno', 'ba-book-everything' ),
                'SAM' => __( 'San Martín', 'ba-book-everything' ),
                'TAC' => __( 'Tacna', 'ba-book-everything' ),
                'TUM' => __( 'Tumbes', 'ba-book-everything' ),
                'UCA' => __( 'Ucayali', 'ba-book-everything' ),
            ),

            /**
             * Philippine Provinces.
             */
            'PH' => array(
                'ABR' => __( 'Abra', 'ba-book-everything' ),
                'AGN' => __( 'Agusan del Norte', 'ba-book-everything' ),
                'AGS' => __( 'Agusan del Sur', 'ba-book-everything' ),
                'AKL' => __( 'Aklan', 'ba-book-everything' ),
                'ALB' => __( 'Albay', 'ba-book-everything' ),
                'ANT' => __( 'Antique', 'ba-book-everything' ),
                'APA' => __( 'Apayao', 'ba-book-everything' ),
                'AUR' => __( 'Aurora', 'ba-book-everything' ),
                'BAS' => __( 'Basilan', 'ba-book-everything' ),
                'BAN' => __( 'Bataan', 'ba-book-everything' ),
                'BTN' => __( 'Batanes', 'ba-book-everything' ),
                'BTG' => __( 'Batangas', 'ba-book-everything' ),
                'BEN' => __( 'Benguet', 'ba-book-everything' ),
                'BIL' => __( 'Biliran', 'ba-book-everything' ),
                'BOH' => __( 'Bohol', 'ba-book-everything' ),
                'BUK' => __( 'Bukidnon', 'ba-book-everything' ),
                'BUL' => __( 'Bulacan', 'ba-book-everything' ),
                'CAG' => __( 'Cagayan', 'ba-book-everything' ),
                'CAN' => __( 'Camarines Norte', 'ba-book-everything' ),
                'CAS' => __( 'Camarines Sur', 'ba-book-everything' ),
                'CAM' => __( 'Camiguin', 'ba-book-everything' ),
                'CAP' => __( 'Capiz', 'ba-book-everything' ),
                'CAT' => __( 'Catanduanes', 'ba-book-everything' ),
                'CAV' => __( 'Cavite', 'ba-book-everything' ),
                'CEB' => __( 'Cebu', 'ba-book-everything' ),
                'COM' => __( 'Compostela Valley', 'ba-book-everything' ),
                'NCO' => __( 'Cotabato', 'ba-book-everything' ),
                'DAV' => __( 'Davao del Norte', 'ba-book-everything' ),
                'DAS' => __( 'Davao del Sur', 'ba-book-everything' ),
                'DAC' => __( 'Davao Occidental', 'ba-book-everything' ),
                'DAO' => __( 'Davao Oriental', 'ba-book-everything' ),
                'DIN' => __( 'Dinagat Islands', 'ba-book-everything' ),
                'EAS' => __( 'Eastern Samar', 'ba-book-everything' ),
                'GUI' => __( 'Guimaras', 'ba-book-everything' ),
                'IFU' => __( 'Ifugao', 'ba-book-everything' ),
                'ILN' => __( 'Ilocos Norte', 'ba-book-everything' ),
                'ILS' => __( 'Ilocos Sur', 'ba-book-everything' ),
                'ILI' => __( 'Iloilo', 'ba-book-everything' ),
                'ISA' => __( 'Isabela', 'ba-book-everything' ),
                'KAL' => __( 'Kalinga', 'ba-book-everything' ),
                'LUN' => __( 'La Union', 'ba-book-everything' ),
                'LAG' => __( 'Laguna', 'ba-book-everything' ),
                'LAN' => __( 'Lanao del Norte', 'ba-book-everything' ),
                'LAS' => __( 'Lanao del Sur', 'ba-book-everything' ),
                'LEY' => __( 'Leyte', 'ba-book-everything' ),
                'MAG' => __( 'Maguindanao', 'ba-book-everything' ),
                'MAD' => __( 'Marinduque', 'ba-book-everything' ),
                'MAS' => __( 'Masbate', 'ba-book-everything' ),
                'MSC' => __( 'Misamis Occidental', 'ba-book-everything' ),
                'MSR' => __( 'Misamis Oriental', 'ba-book-everything' ),
                'MOU' => __( 'Mountain Province', 'ba-book-everything' ),
                'NEC' => __( 'Negros Occidental', 'ba-book-everything' ),
                'NER' => __( 'Negros Oriental', 'ba-book-everything' ),
                'NSA' => __( 'Northern Samar', 'ba-book-everything' ),
                'NUE' => __( 'Nueva Ecija', 'ba-book-everything' ),
                'NUV' => __( 'Nueva Vizcaya', 'ba-book-everything' ),
                'MDC' => __( 'Occidental Mindoro', 'ba-book-everything' ),
                'MDR' => __( 'Oriental Mindoro', 'ba-book-everything' ),
                'PLW' => __( 'Palawan', 'ba-book-everything' ),
                'PAM' => __( 'Pampanga', 'ba-book-everything' ),
                'PAN' => __( 'Pangasinan', 'ba-book-everything' ),
                'QUE' => __( 'Quezon', 'ba-book-everything' ),
                'QUI' => __( 'Quirino', 'ba-book-everything' ),
                'RIZ' => __( 'Rizal', 'ba-book-everything' ),
                'ROM' => __( 'Romblon', 'ba-book-everything' ),
                'WSA' => __( 'Samar', 'ba-book-everything' ),
                'SAR' => __( 'Sarangani', 'ba-book-everything' ),
                'SIQ' => __( 'Siquijor', 'ba-book-everything' ),
                'SOR' => __( 'Sorsogon', 'ba-book-everything' ),
                'SCO' => __( 'South Cotabato', 'ba-book-everything' ),
                'SLE' => __( 'Southern Leyte', 'ba-book-everything' ),
                'SUK' => __( 'Sultan Kudarat', 'ba-book-everything' ),
                'SLU' => __( 'Sulu', 'ba-book-everything' ),
                'SUN' => __( 'Surigao del Norte', 'ba-book-everything' ),
                'SUR' => __( 'Surigao del Sur', 'ba-book-everything' ),
                'TAR' => __( 'Tarlac', 'ba-book-everything' ),
                'TAW' => __( 'Tawi-Tawi', 'ba-book-everything' ),
                'ZMB' => __( 'Zambales', 'ba-book-everything' ),
                'ZAN' => __( 'Zamboanga del Norte', 'ba-book-everything' ),
                'ZAS' => __( 'Zamboanga del Sur', 'ba-book-everything' ),
                'ZSI' => __( 'Zamboanga Sibugay', 'ba-book-everything' ),
                '00'  => __( 'Metro Manila', 'ba-book-everything' ),
            ),
            'PK' => array( // Pakistan's states.
                'JK' => __( 'Azad Kashmir', 'ba-book-everything' ),
                'BA' => __( 'Balochistan', 'ba-book-everything' ),
                'TA' => __( 'FATA', 'ba-book-everything' ),
                'GB' => __( 'Gilgit Baltistan', 'ba-book-everything' ),
                'IS' => __( 'Islamabad Capital Territory', 'ba-book-everything' ),
                'KP' => __( 'Khyber Pakhtunkhwa', 'ba-book-everything' ),
                'PB' => __( 'Punjab', 'ba-book-everything' ),
                'SD' => __( 'Sindh', 'ba-book-everything' ),
            ),
            'PL' => array(),
            'PR' => array(),
            'PT' => array(
                'AC' => __( 'Azores',           'ba-book-everything' ),
                'AV' => __( 'Aveiro',           'ba-book-everything' ),
                'BJ' => __( 'Beja',             'ba-book-everything' ),
                'BR' => __( 'Braga',            'ba-book-everything' ),
                'BG' => __( 'Bragança',         'ba-book-everything' ),
                'CB' => __( 'Castelo Branco',   'ba-book-everything' ),
                'CM' => __( 'Coimbra',          'ba-book-everything' ),
                'EV' => __( 'Évora',            'ba-book-everything' ),
                'FR' => __( 'Faro',             'ba-book-everything' ),
                'GD' => __( 'Guarda',           'ba-book-everything' ),
                'LR' => __( 'Leiria',           'ba-book-everything' ),
                'LS' => __( 'Lisbon',           'ba-book-everything' ),
                'MD' => __( 'Madeira',          'ba-book-everything' ),
                'PR' => __( 'Portalegre',       'ba-book-everything' ),
                'PT' => __( 'Oporto',           'ba-book-everything' ),
                'ST' => __( 'Santarém',         'ba-book-everything' ),
                'SB' => __( 'Setúbal',          'ba-book-everything' ),
                'VC' => __( 'Viana do Castelo', 'ba-book-everything' ),
                'VR' => __( 'Vila Real',        'ba-book-everything' ),
                'VS' => __( 'Viseu',            'ba-book-everything' ),
            ),
            'PY' => array( // Paraguay states.
                'PY-ASU' => __( 'Asunción', 'ba-book-everything' ),
                'PY-1'   => __( 'Concepción', 'ba-book-everything' ),
                'PY-2'   => __( 'San Pedro', 'ba-book-everything' ),
                'PY-3'   => __( 'Cordillera', 'ba-book-everything' ),
                'PY-4'   => __( 'Guairá', 'ba-book-everything' ),
                'PY-5'   => __( 'Caaguazú', 'ba-book-everything' ),
                'PY-6'   => __( 'Caazapá', 'ba-book-everything' ),
                'PY-7'   => __( 'Itapúa', 'ba-book-everything' ),
                'PY-8'   => __( 'Misiones', 'ba-book-everything' ),
                'PY-9'   => __( 'Paraguarí', 'ba-book-everything' ),
                'PY-10'  => __( 'Alto Paraná', 'ba-book-everything' ),
                'PY-11'  => __( 'Central', 'ba-book-everything' ),
                'PY-12'  => __( 'Ñeembucú', 'ba-book-everything' ),
                'PY-13'  => __( 'Amambay', 'ba-book-everything' ),
                'PY-14'  => __( 'Canindeyú', 'ba-book-everything' ),
                'PY-15'  => __( 'Presidente Hayes', 'ba-book-everything' ),
                'PY-16'  => __( 'Alto Paraguay', 'ba-book-everything' ),
                'PY-17'  => __( 'Boquerón', 'ba-book-everything' ),
            ),
            'RE' => array(),
            'RO' => array( // Romania states.
                'AB' => __( 'Alba', 'ba-book-everything' ),
                'AR' => __( 'Arad', 'ba-book-everything' ),
                'AG' => __( 'Argeș', 'ba-book-everything' ),
                'BC' => __( 'Bacău', 'ba-book-everything' ),
                'BH' => __( 'Bihor', 'ba-book-everything' ),
                'BN' => __( 'Bistrița-Năsăud', 'ba-book-everything' ),
                'BT' => __( 'Botoșani', 'ba-book-everything' ),
                'BR' => __( 'Brăila', 'ba-book-everything' ),
                'BV' => __( 'Brașov', 'ba-book-everything' ),
                'B'  => __( 'București', 'ba-book-everything' ),
                'BZ' => __( 'Buzău', 'ba-book-everything' ),
                'CL' => __( 'Călărași', 'ba-book-everything' ),
                'CS' => __( 'Caraș-Severin', 'ba-book-everything' ),
                'CJ' => __( 'Cluj', 'ba-book-everything' ),
                'CT' => __( 'Constanța', 'ba-book-everything' ),
                'CV' => __( 'Covasna', 'ba-book-everything' ),
                'DB' => __( 'Dâmbovița', 'ba-book-everything' ),
                'DJ' => __( 'Dolj', 'ba-book-everything' ),
                'GL' => __( 'Galați', 'ba-book-everything' ),
                'GR' => __( 'Giurgiu', 'ba-book-everything' ),
                'GJ' => __( 'Gorj', 'ba-book-everything' ),
                'HR' => __( 'Harghita', 'ba-book-everything' ),
                'HD' => __( 'Hunedoara', 'ba-book-everything' ),
                'IL' => __( 'Ialomița', 'ba-book-everything' ),
                'IS' => __( 'Iași', 'ba-book-everything' ),
                'IF' => __( 'Ilfov', 'ba-book-everything' ),
                'MM' => __( 'Maramureș', 'ba-book-everything' ),
                'MH' => __( 'Mehedinți', 'ba-book-everything' ),
                'MS' => __( 'Mureș', 'ba-book-everything' ),
                'NT' => __( 'Neamț', 'ba-book-everything' ),
                'OT' => __( 'Olt', 'ba-book-everything' ),
                'PH' => __( 'Prahova', 'ba-book-everything' ),
                'SJ' => __( 'Sălaj', 'ba-book-everything' ),
                'SM' => __( 'Satu Mare', 'ba-book-everything' ),
                'SB' => __( 'Sibiu', 'ba-book-everything' ),
                'SV' => __( 'Suceava', 'ba-book-everything' ),
                'TR' => __( 'Teleorman', 'ba-book-everything' ),
                'TM' => __( 'Timiș', 'ba-book-everything' ),
                'TL' => __( 'Tulcea', 'ba-book-everything' ),
                'VL' => __( 'Vâlcea', 'ba-book-everything' ),
                'VS' => __( 'Vaslui', 'ba-book-everything' ),
                'VN' => __( 'Vrancea', 'ba-book-everything' ),
            ),
            'SG' => array(),
            'SK' => array(),
            'SI' => array(),
            'TH' => array( // Thailand states.
                'TH-37' => __( 'Amnat Charoen', 'ba-book-everything' ),
                'TH-15' => __( 'Ang Thong', 'ba-book-everything' ),
                'TH-14' => __( 'Ayutthaya', 'ba-book-everything' ),
                'TH-10' => __( 'Bangkok', 'ba-book-everything' ),
                'TH-38' => __( 'Bueng Kan', 'ba-book-everything' ),
                'TH-31' => __( 'Buri Ram', 'ba-book-everything' ),
                'TH-24' => __( 'Chachoengsao', 'ba-book-everything' ),
                'TH-18' => __( 'Chai Nat', 'ba-book-everything' ),
                'TH-36' => __( 'Chaiyaphum', 'ba-book-everything' ),
                'TH-22' => __( 'Chanthaburi', 'ba-book-everything' ),
                'TH-50' => __( 'Chiang Mai', 'ba-book-everything' ),
                'TH-57' => __( 'Chiang Rai', 'ba-book-everything' ),
                'TH-20' => __( 'Chonburi', 'ba-book-everything' ),
                'TH-86' => __( 'Chumphon', 'ba-book-everything' ),
                'TH-46' => __( 'Kalasin', 'ba-book-everything' ),
                'TH-62' => __( 'Kamphaeng Phet', 'ba-book-everything' ),
                'TH-71' => __( 'Kanchanaburi', 'ba-book-everything' ),
                'TH-40' => __( 'Khon Kaen', 'ba-book-everything' ),
                'TH-81' => __( 'Krabi', 'ba-book-everything' ),
                'TH-52' => __( 'Lampang', 'ba-book-everything' ),
                'TH-51' => __( 'Lamphun', 'ba-book-everything' ),
                'TH-42' => __( 'Loei', 'ba-book-everything' ),
                'TH-16' => __( 'Lopburi', 'ba-book-everything' ),
                'TH-58' => __( 'Mae Hong Son', 'ba-book-everything' ),
                'TH-44' => __( 'Maha Sarakham', 'ba-book-everything' ),
                'TH-49' => __( 'Mukdahan', 'ba-book-everything' ),
                'TH-26' => __( 'Nakhon Nayok', 'ba-book-everything' ),
                'TH-73' => __( 'Nakhon Pathom', 'ba-book-everything' ),
                'TH-48' => __( 'Nakhon Phanom', 'ba-book-everything' ),
                'TH-30' => __( 'Nakhon Ratchasima', 'ba-book-everything' ),
                'TH-60' => __( 'Nakhon Sawan', 'ba-book-everything' ),
                'TH-80' => __( 'Nakhon Si Thammarat', 'ba-book-everything' ),
                'TH-55' => __( 'Nan', 'ba-book-everything' ),
                'TH-96' => __( 'Narathiwat', 'ba-book-everything' ),
                'TH-39' => __( 'Nong Bua Lam Phu', 'ba-book-everything' ),
                'TH-43' => __( 'Nong Khai', 'ba-book-everything' ),
                'TH-12' => __( 'Nonthaburi', 'ba-book-everything' ),
                'TH-13' => __( 'Pathum Thani', 'ba-book-everything' ),
                'TH-94' => __( 'Pattani', 'ba-book-everything' ),
                'TH-82' => __( 'Phang Nga', 'ba-book-everything' ),
                'TH-93' => __( 'Phatthalung', 'ba-book-everything' ),
                'TH-56' => __( 'Phayao', 'ba-book-everything' ),
                'TH-67' => __( 'Phetchabun', 'ba-book-everything' ),
                'TH-76' => __( 'Phetchaburi', 'ba-book-everything' ),
                'TH-66' => __( 'Phichit', 'ba-book-everything' ),
                'TH-65' => __( 'Phitsanulok', 'ba-book-everything' ),
                'TH-54' => __( 'Phrae', 'ba-book-everything' ),
                'TH-83' => __( 'Phuket', 'ba-book-everything' ),
                'TH-25' => __( 'Prachin Buri', 'ba-book-everything' ),
                'TH-77' => __( 'Prachuap Khiri Khan', 'ba-book-everything' ),
                'TH-85' => __( 'Ranong', 'ba-book-everything' ),
                'TH-70' => __( 'Ratchaburi', 'ba-book-everything' ),
                'TH-21' => __( 'Rayong', 'ba-book-everything' ),
                'TH-45' => __( 'Roi Et', 'ba-book-everything' ),
                'TH-27' => __( 'Sa Kaeo', 'ba-book-everything' ),
                'TH-47' => __( 'Sakon Nakhon', 'ba-book-everything' ),
                'TH-11' => __( 'Samut Prakan', 'ba-book-everything' ),
                'TH-74' => __( 'Samut Sakhon', 'ba-book-everything' ),
                'TH-75' => __( 'Samut Songkhram', 'ba-book-everything' ),
                'TH-19' => __( 'Saraburi', 'ba-book-everything' ),
                'TH-91' => __( 'Satun', 'ba-book-everything' ),
                'TH-17' => __( 'Sing Buri', 'ba-book-everything' ),
                'TH-33' => __( 'Sisaket', 'ba-book-everything' ),
                'TH-90' => __( 'Songkhla', 'ba-book-everything' ),
                'TH-64' => __( 'Sukhothai', 'ba-book-everything' ),
                'TH-72' => __( 'Suphan Buri', 'ba-book-everything' ),
                'TH-84' => __( 'Surat Thani', 'ba-book-everything' ),
                'TH-32' => __( 'Surin', 'ba-book-everything' ),
                'TH-63' => __( 'Tak', 'ba-book-everything' ),
                'TH-92' => __( 'Trang', 'ba-book-everything' ),
                'TH-23' => __( 'Trat', 'ba-book-everything' ),
                'TH-34' => __( 'Ubon Ratchathani', 'ba-book-everything' ),
                'TH-41' => __( 'Udon Thani', 'ba-book-everything' ),
                'TH-61' => __( 'Uthai Thani', 'ba-book-everything' ),
                'TH-53' => __( 'Uttaradit', 'ba-book-everything' ),
                'TH-95' => __( 'Yala', 'ba-book-everything' ),
                'TH-35' => __( 'Yasothon', 'ba-book-everything' ),
            ),
            'TR' => array( // Turkey States.
                'TR01' => __( 'Adana', 'ba-book-everything' ),
                'TR02' => __( 'Adıyaman', 'ba-book-everything' ),
                'TR03' => __( 'Afyon', 'ba-book-everything' ),
                'TR04' => __( 'Ağrı', 'ba-book-everything' ),
                'TR05' => __( 'Amasya', 'ba-book-everything' ),
                'TR06' => __( 'Ankara', 'ba-book-everything' ),
                'TR07' => __( 'Antalya', 'ba-book-everything' ),
                'TR08' => __( 'Artvin', 'ba-book-everything' ),
                'TR09' => __( 'Aydın', 'ba-book-everything' ),
                'TR10' => __( 'Balıkesir', 'ba-book-everything' ),
                'TR11' => __( 'Bilecik', 'ba-book-everything' ),
                'TR12' => __( 'Bingöl', 'ba-book-everything' ),
                'TR13' => __( 'Bitlis', 'ba-book-everything' ),
                'TR14' => __( 'Bolu', 'ba-book-everything' ),
                'TR15' => __( 'Burdur', 'ba-book-everything' ),
                'TR16' => __( 'Bursa', 'ba-book-everything' ),
                'TR17' => __( 'Çanakkale', 'ba-book-everything' ),
                'TR18' => __( 'Çankırı', 'ba-book-everything' ),
                'TR19' => __( 'Çorum', 'ba-book-everything' ),
                'TR20' => __( 'Denizli', 'ba-book-everything' ),
                'TR21' => __( 'Diyarbakır', 'ba-book-everything' ),
                'TR22' => __( 'Edirne', 'ba-book-everything' ),
                'TR23' => __( 'Elazığ', 'ba-book-everything' ),
                'TR24' => __( 'Erzincan', 'ba-book-everything' ),
                'TR25' => __( 'Erzurum', 'ba-book-everything' ),
                'TR26' => __( 'Eskişehir', 'ba-book-everything' ),
                'TR27' => __( 'Gaziantep', 'ba-book-everything' ),
                'TR28' => __( 'Giresun', 'ba-book-everything' ),
                'TR29' => __( 'Gümüşhane', 'ba-book-everything' ),
                'TR30' => __( 'Hakkari', 'ba-book-everything' ),
                'TR31' => __( 'Hatay', 'ba-book-everything' ),
                'TR32' => __( 'Isparta', 'ba-book-everything' ),
                'TR33' => __( 'İçel', 'ba-book-everything' ),
                'TR34' => __( 'İstanbul', 'ba-book-everything' ),
                'TR35' => __( 'İzmir', 'ba-book-everything' ),
                'TR36' => __( 'Kars', 'ba-book-everything' ),
                'TR37' => __( 'Kastamonu', 'ba-book-everything' ),
                'TR38' => __( 'Kayseri', 'ba-book-everything' ),
                'TR39' => __( 'Kırklareli', 'ba-book-everything' ),
                'TR40' => __( 'Kırşehir', 'ba-book-everything' ),
                'TR41' => __( 'Kocaeli', 'ba-book-everything' ),
                'TR42' => __( 'Konya', 'ba-book-everything' ),
                'TR43' => __( 'Kütahya', 'ba-book-everything' ),
                'TR44' => __( 'Malatya', 'ba-book-everything' ),
                'TR45' => __( 'Manisa', 'ba-book-everything' ),
                'TR46' => __( 'Kahramanmaraş', 'ba-book-everything' ),
                'TR47' => __( 'Mardin', 'ba-book-everything' ),
                'TR48' => __( 'Muğla', 'ba-book-everything' ),
                'TR49' => __( 'Muş', 'ba-book-everything' ),
                'TR50' => __( 'Nevşehir', 'ba-book-everything' ),
                'TR51' => __( 'Niğde', 'ba-book-everything' ),
                'TR52' => __( 'Ordu', 'ba-book-everything' ),
                'TR53' => __( 'Rize', 'ba-book-everything' ),
                'TR54' => __( 'Sakarya', 'ba-book-everything' ),
                'TR55' => __( 'Samsun', 'ba-book-everything' ),
                'TR56' => __( 'Siirt', 'ba-book-everything' ),
                'TR57' => __( 'Sinop', 'ba-book-everything' ),
                'TR58' => __( 'Sivas', 'ba-book-everything' ),
                'TR59' => __( 'Tekirdağ', 'ba-book-everything' ),
                'TR60' => __( 'Tokat', 'ba-book-everything' ),
                'TR61' => __( 'Trabzon', 'ba-book-everything' ),
                'TR62' => __( 'Tunceli', 'ba-book-everything' ),
                'TR63' => __( 'Şanlıurfa', 'ba-book-everything' ),
                'TR64' => __( 'Uşak', 'ba-book-everything' ),
                'TR65' => __( 'Van', 'ba-book-everything' ),
                'TR66' => __( 'Yozgat', 'ba-book-everything' ),
                'TR67' => __( 'Zonguldak', 'ba-book-everything' ),
                'TR68' => __( 'Aksaray', 'ba-book-everything' ),
                'TR69' => __( 'Bayburt', 'ba-book-everything' ),
                'TR70' => __( 'Karaman', 'ba-book-everything' ),
                'TR71' => __( 'Kırıkkale', 'ba-book-everything' ),
                'TR72' => __( 'Batman', 'ba-book-everything' ),
                'TR73' => __( 'Şırnak', 'ba-book-everything' ),
                'TR74' => __( 'Bartın', 'ba-book-everything' ),
                'TR75' => __( 'Ardahan', 'ba-book-everything' ),
                'TR76' => __( 'Iğdır', 'ba-book-everything' ),
                'TR77' => __( 'Yalova', 'ba-book-everything' ),
                'TR78' => __( 'Karabük', 'ba-book-everything' ),
                'TR79' => __( 'Kilis', 'ba-book-everything' ),
                'TR80' => __( 'Osmaniye', 'ba-book-everything' ),
                'TR81' => __( 'Düzce', 'ba-book-everything' ),
            ),
            'TZ' => array( // Tanzania States.
                'TZ01' => __( 'Arusha', 'ba-book-everything' ),
                'TZ02' => __( 'Dar es Salaam', 'ba-book-everything' ),
                'TZ03' => __( 'Dodoma', 'ba-book-everything' ),
                'TZ04' => __( 'Iringa', 'ba-book-everything' ),
                'TZ05' => __( 'Kagera', 'ba-book-everything' ),
                'TZ06' => __( 'Pemba North', 'ba-book-everything' ),
                'TZ07' => __( 'Zanzibar North', 'ba-book-everything' ),
                'TZ08' => __( 'Kigoma', 'ba-book-everything' ),
                'TZ09' => __( 'Kilimanjaro', 'ba-book-everything' ),
                'TZ10' => __( 'Pemba South', 'ba-book-everything' ),
                'TZ11' => __( 'Zanzibar South', 'ba-book-everything' ),
                'TZ12' => __( 'Lindi', 'ba-book-everything' ),
                'TZ13' => __( 'Mara', 'ba-book-everything' ),
                'TZ14' => __( 'Mbeya', 'ba-book-everything' ),
                'TZ15' => __( 'Zanzibar West', 'ba-book-everything' ),
                'TZ16' => __( 'Morogoro', 'ba-book-everything' ),
                'TZ17' => __( 'Mtwara', 'ba-book-everything' ),
                'TZ18' => __( 'Mwanza', 'ba-book-everything' ),
                'TZ19' => __( 'Coast', 'ba-book-everything' ),
                'TZ20' => __( 'Rukwa', 'ba-book-everything' ),
                'TZ21' => __( 'Ruvuma', 'ba-book-everything' ),
                'TZ22' => __( 'Shinyanga', 'ba-book-everything' ),
                'TZ23' => __( 'Singida', 'ba-book-everything' ),
                'TZ24' => __( 'Tabora', 'ba-book-everything' ),
                'TZ25' => __( 'Tanga', 'ba-book-everything' ),
                'TZ26' => __( 'Manyara', 'ba-book-everything' ),
                'TZ27' => __( 'Geita', 'ba-book-everything' ),
                'TZ28' => __( 'Katavi', 'ba-book-everything' ),
                'TZ29' => __( 'Njombe', 'ba-book-everything' ),
                'TZ30' => __( 'Simiyu', 'ba-book-everything' ),
            ),
            'LK' => array(),
            'RS' => array( // Serbia districts. Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
                'RS00' => _x( 'Belgrade', 'district', 'ba-book-everything' ),
                'RS14' => _x( 'Bor', 'district', 'ba-book-everything' ),
                'RS11' => _x( 'Braničevo', 'district', 'ba-book-everything' ),
                'RS02' => _x( 'Central Banat', 'district', 'ba-book-everything' ),
                'RS10' => _x( 'Danube', 'district', 'ba-book-everything' ),
                'RS23' => _x( 'Jablanica', 'district', 'ba-book-everything' ),
                'RS09' => _x( 'Kolubara', 'district', 'ba-book-everything' ),
                'RS08' => _x( 'Mačva', 'district', 'ba-book-everything' ),
                'RS17' => _x( 'Morava', 'district', 'ba-book-everything' ),
                'RS20' => _x( 'Nišava', 'district', 'ba-book-everything' ),
                'RS01' => _x( 'North Bačka', 'district', 'ba-book-everything' ),
                'RS03' => _x( 'North Banat', 'district', 'ba-book-everything' ),
                'RS24' => _x( 'Pčinja', 'district', 'ba-book-everything' ),
                'RS22' => _x( 'Pirot', 'district', 'ba-book-everything' ),
                'RS13' => _x( 'Pomoravlje', 'district', 'ba-book-everything' ),
                'RS19' => _x( 'Rasina', 'district', 'ba-book-everything' ),
                'RS18' => _x( 'Raška', 'district', 'ba-book-everything' ),
                'RS06' => _x( 'South Bačka', 'district', 'ba-book-everything' ),
                'RS04' => _x( 'South Banat', 'district', 'ba-book-everything' ),
                'RS07' => _x( 'Srem', 'district', 'ba-book-everything' ),
                'RS12' => _x( 'Šumadija', 'district', 'ba-book-everything' ),
                'RS21' => _x( 'Toplica', 'district', 'ba-book-everything' ),
                'RS05' => _x( 'West Bačka', 'district', 'ba-book-everything' ),
                'RS15' => _x( 'Zaječar', 'district', 'ba-book-everything' ),
                'RS16' => _x( 'Zlatibor', 'district', 'ba-book-everything' ),
                'RS25' => _x( 'Kosovo', 'district', 'ba-book-everything' ),
                'RS26' => _x( 'Peć', 'district', 'ba-book-everything' ),
                'RS27' => _x( 'Prizren', 'district', 'ba-book-everything' ),
                'RS28' => _x( 'Kosovska Mitrovica', 'district', 'ba-book-everything' ),
                'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'ba-book-everything' ),
                'RSKM' => _x( 'Kosovo-Metohija', 'district', 'ba-book-everything' ),
                'RSVO' => _x( 'Vojvodina', 'district', 'ba-book-everything' ),
            ),
            'SE' => array(),
            'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
                'UG314' => __( 'Abim', 'ba-book-everything' ),
                'UG301' => __( 'Adjumani', 'ba-book-everything' ),
                'UG322' => __( 'Agago', 'ba-book-everything' ),
                'UG323' => __( 'Alebtong', 'ba-book-everything' ),
                'UG315' => __( 'Amolatar', 'ba-book-everything' ),
                'UG324' => __( 'Amudat', 'ba-book-everything' ),
                'UG216' => __( 'Amuria', 'ba-book-everything' ),
                'UG316' => __( 'Amuru', 'ba-book-everything' ),
                'UG302' => __( 'Apac', 'ba-book-everything' ),
                'UG303' => __( 'Arua', 'ba-book-everything' ),
                'UG217' => __( 'Budaka', 'ba-book-everything' ),
                'UG218' => __( 'Bududa', 'ba-book-everything' ),
                'UG201' => __( 'Bugiri', 'ba-book-everything' ),
                'UG235' => __( 'Bugweri', 'ba-book-everything' ),
                'UG420' => __( 'Buhweju', 'ba-book-everything' ),
                'UG117' => __( 'Buikwe', 'ba-book-everything' ),
                'UG219' => __( 'Bukedea', 'ba-book-everything' ),
                'UG118' => __( 'Bukomansimbi', 'ba-book-everything' ),
                'UG220' => __( 'Bukwa', 'ba-book-everything' ),
                'UG225' => __( 'Bulambuli', 'ba-book-everything' ),
                'UG416' => __( 'Buliisa', 'ba-book-everything' ),
                'UG401' => __( 'Bundibugyo', 'ba-book-everything' ),
                'UG430' => __( 'Bunyangabu', 'ba-book-everything' ),
                'UG402' => __( 'Bushenyi', 'ba-book-everything' ),
                'UG202' => __( 'Busia', 'ba-book-everything' ),
                'UG221' => __( 'Butaleja', 'ba-book-everything' ),
                'UG119' => __( 'Butambala', 'ba-book-everything' ),
                'UG233' => __( 'Butebo', 'ba-book-everything' ),
                'UG120' => __( 'Buvuma', 'ba-book-everything' ),
                'UG226' => __( 'Buyende', 'ba-book-everything' ),
                'UG317' => __( 'Dokolo', 'ba-book-everything' ),
                'UG121' => __( 'Gomba', 'ba-book-everything' ),
                'UG304' => __( 'Gulu', 'ba-book-everything' ),
                'UG403' => __( 'Hoima', 'ba-book-everything' ),
                'UG417' => __( 'Ibanda', 'ba-book-everything' ),
                'UG203' => __( 'Iganga', 'ba-book-everything' ),
                'UG418' => __( 'Isingiro', 'ba-book-everything' ),
                'UG204' => __( 'Jinja', 'ba-book-everything' ),
                'UG318' => __( 'Kaabong', 'ba-book-everything' ),
                'UG404' => __( 'Kabale', 'ba-book-everything' ),
                'UG405' => __( 'Kabarole', 'ba-book-everything' ),
                'UG213' => __( 'Kaberamaido', 'ba-book-everything' ),
                'UG427' => __( 'Kagadi', 'ba-book-everything' ),
                'UG428' => __( 'Kakumiro', 'ba-book-everything' ),
                'UG101' => __( 'Kalangala', 'ba-book-everything' ),
                'UG222' => __( 'Kaliro', 'ba-book-everything' ),
                'UG122' => __( 'Kalungu', 'ba-book-everything' ),
                'UG102' => __( 'Kampala', 'ba-book-everything' ),
                'UG205' => __( 'Kamuli', 'ba-book-everything' ),
                'UG413' => __( 'Kamwenge', 'ba-book-everything' ),
                'UG414' => __( 'Kanungu', 'ba-book-everything' ),
                'UG206' => __( 'Kapchorwa', 'ba-book-everything' ),
                'UG236' => __( 'Kapelebyong', 'ba-book-everything' ),
                'UG126' => __( 'Kasanda', 'ba-book-everything' ),
                'UG406' => __( 'Kasese', 'ba-book-everything' ),
                'UG207' => __( 'Katakwi', 'ba-book-everything' ),
                'UG112' => __( 'Kayunga', 'ba-book-everything' ),
                'UG407' => __( 'Kibaale', 'ba-book-everything' ),
                'UG103' => __( 'Kiboga', 'ba-book-everything' ),
                'UG227' => __( 'Kibuku', 'ba-book-everything' ),
                'UG432' => __( 'Kikuube', 'ba-book-everything' ),
                'UG419' => __( 'Kiruhura', 'ba-book-everything' ),
                'UG421' => __( 'Kiryandongo', 'ba-book-everything' ),
                'UG408' => __( 'Kisoro', 'ba-book-everything' ),
                'UG305' => __( 'Kitgum', 'ba-book-everything' ),
                'UG319' => __( 'Koboko', 'ba-book-everything' ),
                'UG325' => __( 'Kole', 'ba-book-everything' ),
                'UG306' => __( 'Kotido', 'ba-book-everything' ),
                'UG208' => __( 'Kumi', 'ba-book-everything' ),
                'UG333' => __( 'Kwania', 'ba-book-everything' ),
                'UG228' => __( 'Kween', 'ba-book-everything' ),
                'UG123' => __( 'Kyankwanzi', 'ba-book-everything' ),
                'UG422' => __( 'Kyegegwa', 'ba-book-everything' ),
                'UG415' => __( 'Kyenjojo', 'ba-book-everything' ),
                'UG125' => __( 'Kyotera', 'ba-book-everything' ),
                'UG326' => __( 'Lamwo', 'ba-book-everything' ),
                'UG307' => __( 'Lira', 'ba-book-everything' ),
                'UG229' => __( 'Luuka', 'ba-book-everything' ),
                'UG104' => __( 'Luwero', 'ba-book-everything' ),
                'UG124' => __( 'Lwengo', 'ba-book-everything' ),
                'UG114' => __( 'Lyantonde', 'ba-book-everything' ),
                'UG223' => __( 'Manafwa', 'ba-book-everything' ),
                'UG320' => __( 'Maracha', 'ba-book-everything' ),
                'UG105' => __( 'Masaka', 'ba-book-everything' ),
                'UG409' => __( 'Masindi', 'ba-book-everything' ),
                'UG214' => __( 'Mayuge', 'ba-book-everything' ),
                'UG209' => __( 'Mbale', 'ba-book-everything' ),
                'UG410' => __( 'Mbarara', 'ba-book-everything' ),
                'UG423' => __( 'Mitooma', 'ba-book-everything' ),
                'UG115' => __( 'Mityana', 'ba-book-everything' ),
                'UG308' => __( 'Moroto', 'ba-book-everything' ),
                'UG309' => __( 'Moyo', 'ba-book-everything' ),
                'UG106' => __( 'Mpigi', 'ba-book-everything' ),
                'UG107' => __( 'Mubende', 'ba-book-everything' ),
                'UG108' => __( 'Mukono', 'ba-book-everything' ),
                'UG334' => __( 'Nabilatuk', 'ba-book-everything' ),
                'UG311' => __( 'Nakapiripirit', 'ba-book-everything' ),
                'UG116' => __( 'Nakaseke', 'ba-book-everything' ),
                'UG109' => __( 'Nakasongola', 'ba-book-everything' ),
                'UG230' => __( 'Namayingo', 'ba-book-everything' ),
                'UG234' => __( 'Namisindwa', 'ba-book-everything' ),
                'UG224' => __( 'Namutumba', 'ba-book-everything' ),
                'UG327' => __( 'Napak', 'ba-book-everything' ),
                'UG310' => __( 'Nebbi', 'ba-book-everything' ),
                'UG231' => __( 'Ngora', 'ba-book-everything' ),
                'UG424' => __( 'Ntoroko', 'ba-book-everything' ),
                'UG411' => __( 'Ntungamo', 'ba-book-everything' ),
                'UG328' => __( 'Nwoya', 'ba-book-everything' ),
                'UG331' => __( 'Omoro', 'ba-book-everything' ),
                'UG329' => __( 'Otuke', 'ba-book-everything' ),
                'UG321' => __( 'Oyam', 'ba-book-everything' ),
                'UG312' => __( 'Pader', 'ba-book-everything' ),
                'UG332' => __( 'Pakwach', 'ba-book-everything' ),
                'UG210' => __( 'Pallisa', 'ba-book-everything' ),
                'UG110' => __( 'Rakai', 'ba-book-everything' ),
                'UG429' => __( 'Rubanda', 'ba-book-everything' ),
                'UG425' => __( 'Rubirizi', 'ba-book-everything' ),
                'UG431' => __( 'Rukiga', 'ba-book-everything' ),
                'UG412' => __( 'Rukungiri', 'ba-book-everything' ),
                'UG111' => __( 'Sembabule', 'ba-book-everything' ),
                'UG232' => __( 'Serere', 'ba-book-everything' ),
                'UG426' => __( 'Sheema', 'ba-book-everything' ),
                'UG215' => __( 'Sironko', 'ba-book-everything' ),
                'UG211' => __( 'Soroti', 'ba-book-everything' ),
                'UG212' => __( 'Tororo', 'ba-book-everything' ),
                'UG113' => __( 'Wakiso', 'ba-book-everything' ),
                'UG313' => __( 'Yumbe', 'ba-book-everything' ),
                'UG330' => __( 'Zombo', 'ba-book-everything' ),
            ),
            'UM' => array(
                '81' => __( 'Baker Island', 'ba-book-everything' ),
                '84' => __( 'Howland Island', 'ba-book-everything' ),
                '86' => __( 'Jarvis Island', 'ba-book-everything' ),
                '67' => __( 'Johnston Atoll', 'ba-book-everything' ),
                '89' => __( 'Kingman Reef', 'ba-book-everything' ),
                '71' => __( 'Midway Atoll', 'ba-book-everything' ),
                '76' => __( 'Navassa Island', 'ba-book-everything' ),
                '95' => __( 'Palmyra Atoll', 'ba-book-everything' ),
                '79' => __( 'Wake Island', 'ba-book-everything' ),
            ),
            'US' => array( // United States.
                'AL' => __( 'Alabama', 'ba-book-everything' ),
                'AK' => __( 'Alaska', 'ba-book-everything' ),
                'AZ' => __( 'Arizona', 'ba-book-everything' ),
                'AR' => __( 'Arkansas', 'ba-book-everything' ),
                'CA' => __( 'California', 'ba-book-everything' ),
                'CO' => __( 'Colorado', 'ba-book-everything' ),
                'CT' => __( 'Connecticut', 'ba-book-everything' ),
                'DE' => __( 'Delaware', 'ba-book-everything' ),
                'DC' => __( 'District Of Columbia', 'ba-book-everything' ),
                'FL' => __( 'Florida', 'ba-book-everything' ),
                'GA' => _x( 'Georgia', 'US state of Georgia', 'ba-book-everything' ),
                'HI' => __( 'Hawaii', 'ba-book-everything' ),
                'ID' => __( 'Idaho', 'ba-book-everything' ),
                'IL' => __( 'Illinois', 'ba-book-everything' ),
                'IN' => __( 'Indiana', 'ba-book-everything' ),
                'IA' => __( 'Iowa', 'ba-book-everything' ),
                'KS' => __( 'Kansas', 'ba-book-everything' ),
                'KY' => __( 'Kentucky', 'ba-book-everything' ),
                'LA' => __( 'Louisiana', 'ba-book-everything' ),
                'ME' => __( 'Maine', 'ba-book-everything' ),
                'MD' => __( 'Maryland', 'ba-book-everything' ),
                'MA' => __( 'Massachusetts', 'ba-book-everything' ),
                'MI' => __( 'Michigan', 'ba-book-everything' ),
                'MN' => __( 'Minnesota', 'ba-book-everything' ),
                'MS' => __( 'Mississippi', 'ba-book-everything' ),
                'MO' => __( 'Missouri', 'ba-book-everything' ),
                'MT' => __( 'Montana', 'ba-book-everything' ),
                'NE' => __( 'Nebraska', 'ba-book-everything' ),
                'NV' => __( 'Nevada', 'ba-book-everything' ),
                'NH' => __( 'New Hampshire', 'ba-book-everything' ),
                'NJ' => __( 'New Jersey', 'ba-book-everything' ),
                'NM' => __( 'New Mexico', 'ba-book-everything' ),
                'NY' => __( 'New York', 'ba-book-everything' ),
                'NC' => __( 'North Carolina', 'ba-book-everything' ),
                'ND' => __( 'North Dakota', 'ba-book-everything' ),
                'OH' => __( 'Ohio', 'ba-book-everything' ),
                'OK' => __( 'Oklahoma', 'ba-book-everything' ),
                'OR' => __( 'Oregon', 'ba-book-everything' ),
                'PA' => __( 'Pennsylvania', 'ba-book-everything' ),
                'RI' => __( 'Rhode Island', 'ba-book-everything' ),
                'SC' => __( 'South Carolina', 'ba-book-everything' ),
                'SD' => __( 'South Dakota', 'ba-book-everything' ),
                'TN' => __( 'Tennessee', 'ba-book-everything' ),
                'TX' => __( 'Texas', 'ba-book-everything' ),
                'UT' => __( 'Utah', 'ba-book-everything' ),
                'VT' => __( 'Vermont', 'ba-book-everything' ),
                'VA' => __( 'Virginia', 'ba-book-everything' ),
                'WA' => __( 'Washington', 'ba-book-everything' ),
                'WV' => __( 'West Virginia', 'ba-book-everything' ),
                'WI' => __( 'Wisconsin', 'ba-book-everything' ),
                'WY' => __( 'Wyoming', 'ba-book-everything' ),
                'AA' => __( 'Armed Forces (AA)', 'ba-book-everything' ),
                'AE' => __( 'Armed Forces (AE)', 'ba-book-everything' ),
                'AP' => __( 'Armed Forces (AP)', 'ba-book-everything' ),
            ),
            'VN' => array(),
            'YT' => array(),
            'ZA' => array( // South African states.
                'EC'  => __( 'Eastern Cape', 'ba-book-everything' ),
                'FS'  => __( 'Free State', 'ba-book-everything' ),
                'GP'  => __( 'Gauteng', 'ba-book-everything' ),
                'KZN' => __( 'KwaZulu-Natal', 'ba-book-everything' ),
                'LP'  => __( 'Limpopo', 'ba-book-everything' ),
                'MP'  => __( 'Mpumalanga', 'ba-book-everything' ),
                'NC'  => __( 'Northern Cape', 'ba-book-everything' ),
                'NW'  => __( 'North West', 'ba-book-everything' ),
                'WC'  => __( 'Western Cape', 'ba-book-everything' ),
            ),
            'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
                'ZM-01' => __( 'Western', 'ba-book-everything' ),
                'ZM-02' => __( 'Central', 'ba-book-everything' ),
                'ZM-03' => __( 'Eastern', 'ba-book-everything' ),
                'ZM-04' => __( 'Luapula', 'ba-book-everything' ),
                'ZM-05' => __( 'Northern', 'ba-book-everything' ),
                'ZM-06' => __( 'North-Western', 'ba-book-everything' ),
                'ZM-07' => __( 'Southern', 'ba-book-everything' ),
                'ZM-08' => __( 'Copperbelt', 'ba-book-everything' ),
                'ZM-09' => __( 'Lusaka', 'ba-book-everything' ),
                'ZM-10' => __( 'Muchinga', 'ba-book-everything' ),
            ),
        ]);
    }

    /**
     * Returns an array of locale info
     * @return array
     */
    public static function locale_info() {

        return apply_filters( 'babe_locale_info', [
            'AT' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'left',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'AU' => array(
                'currency_code'  => 'AUD',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'BA' => array(
                'currency_code'  => 'BAM',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'BD' => array(
                'currency_code'  => 'BDT',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'in',
            ),
            'BE' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'left',
                'thousand_sep'   => ' ',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'BR' => array(
                'currency_code'  => 'BRL',
                'currency_pos'   => 'left',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'CA' => array(
                'currency_code'  => 'CAD',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'CH' => array(
                'currency_code'  => 'CHF',
                'currency_pos'   => 'left_space',
                'thousand_sep'   => "'",
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'DE' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'left',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'DK' => array(
                'currency_code'  => 'DKK',
                'currency_pos'   => 'left_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'ES' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'right',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'FI' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => ' ',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'FR' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'right',
                'thousand_sep'   => ' ',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'GB' => array(
                'currency_code'  => 'GBP',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'HU' => array(
                'currency_code'  => 'HUF',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => ' ',
                'decimal_sep'    => ',',
                'num_decimals'   => 0,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'IT' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'right',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'JM' => array(
                'currency_code'  => 'JMD',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'lbs',
                'dimension_unit' => 'in',
            ),
            'JP' => array(
                'currency_code'  => 'JPY',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 0,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'KE' => array(
                'currency_code'  => 'KES',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 0,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'KR' => array(
                'currency_code'  => 'KRW',
                'currency_pos'   => 'right',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 0,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'LI' => array(
                'currency_code'  => 'CHF',
                'currency_pos'   => 'left_space',
                'thousand_sep'   => "'",
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'MD' => array(
                'currency_code'  => 'MDL',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'NL' => array(
                'currency_code'  => 'EUR',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'NO' => array(
                'currency_code'  => 'Kr',
                'currency_pos'   => 'left_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'NP' => array(
                'currency_code'  => 'NPR',
                'currency_pos'   => 'left_space',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'PL' => array(
                'currency_code'  => 'PLN',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => ' ',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'PY' => array(
                'currency_code'  => 'PYG',
                'currency_pos'   => 'left',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'RO' => array(
                'currency_code'  => 'RON',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'RS' => array(
                'currency_code'  => 'RSD',
                'currency_pos'   => 'right_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
                'tax_rates'      => array(),
            ),
            'TH' => array(
                'currency_code'  => 'THB',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'TR' => array(
                'currency_code'  => 'TRY',
                'currency_pos'   => 'left_space',
                'thousand_sep'   => '.',
                'decimal_sep'    => ',',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'TZ' => array(
                'currency_code'  => 'TZS',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 0,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'UG' => array(
                'currency_code'  => 'UGX',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 0,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
            'US' => array(
                'currency_code'  => 'USD',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'oz',
                'dimension_unit' => 'in',
            ),
            'ZA' => array(
                'currency_code'  => 'ZAR',
                'currency_pos'   => 'left',
                'thousand_sep'   => ',',
                'decimal_sep'    => '.',
                'num_decimals'   => 2,
                'weight_unit'    => 'kg',
                'dimension_unit' => 'cm',
            ),
        ]);
    }

    /**
     * Returns an array continents
     * @return array
     */
    public static function continents() {
        
        return apply_filters( 'babe_continents', [
            'AF' => array(
                'name'      => __( 'Africa', 'ba-book-everything' ),
                'countries' => array(
                    'AO',
                    'BF',
                    'BI',
                    'BJ',
                    'BW',
                    'CD',
                    'CF',
                    'CG',
                    'CI',
                    'CM',
                    'CV',
                    'DJ',
                    'DZ',
                    'EG',
                    'EH',
                    'ER',
                    'ET',
                    'GA',
                    'GH',
                    'GM',
                    'GN',
                    'GQ',
                    'GW',
                    'KE',
                    'KM',
                    'LR',
                    'LS',
                    'LY',
                    'MA',
                    'MG',
                    'ML',
                    'MR',
                    'MU',
                    'MW',
                    'MZ',
                    'NA',
                    'NE',
                    'NG',
                    'RE',
                    'RW',
                    'SC',
                    'SD',
                    'SH',
                    'SL',
                    'SN',
                    'SO',
                    'SS',
                    'ST',
                    'SZ',
                    'TD',
                    'TG',
                    'TN',
                    'TZ',
                    'UG',
                    'YT',
                    'ZA',
                    'ZM',
                    'ZW',
                ),
            ),
            'AN' => array(
                'name'      => __( 'Antarctica', 'ba-book-everything' ),
                'countries' => array(
                    'AQ',
                    'BV',
                    'GS',
                    'HM',
                    'TF',
                ),
            ),
            'AS' => array(
                'name'      => __( 'Asia', 'ba-book-everything' ),
                'countries' => array(
                    'AE',
                    'AF',
                    'AM',
                    'AZ',
                    'BD',
                    'BH',
                    'BN',
                    'BT',
                    'CC',
                    'CN',
                    'CX',
                    'CY',
                    'GE',
                    'HK',
                    'ID',
                    'IL',
                    'IN',
                    'IO',
                    'IQ',
                    'IR',
                    'JO',
                    'JP',
                    'KG',
                    'KH',
                    'KP',
                    'KR',
                    'KW',
                    'KZ',
                    'LA',
                    'LB',
                    'LK',
                    'MM',
                    'MN',
                    'MO',
                    'MV',
                    'MY',
                    'NP',
                    'OM',
                    'PH',
                    'PK',
                    'PS',
                    'QA',
                    'SA',
                    'SG',
                    'SY',
                    'TH',
                    'TJ',
                    'TL',
                    'TM',
                    'TW',
                    'UZ',
                    'VN',
                    'YE',
                ),
            ),
            'EU' => array(
                'name'      => __( 'Europe', 'ba-book-everything' ),
                'countries' => array(
                    'AD',
                    'AL',
                    'AT',
                    'AX',
                    'BA',
                    'BE',
                    'BG',
                    'BY',
                    'CH',
                    'CZ',
                    'DE',
                    'DK',
                    'EE',
                    'ES',
                    'FI',
                    'FO',
                    'FR',
                    'GB',
                    'GG',
                    'GI',
                    'GR',
                    'HR',
                    'HU',
                    'IE',
                    'IM',
                    'IS',
                    'IT',
                    'JE',
                    'LI',
                    'LT',
                    'LU',
                    'LV',
                    'MC',
                    'MD',
                    'ME',
                    'MK',
                    'MT',
                    'NL',
                    'NO',
                    'PL',
                    'PT',
                    'RO',
                    'RS',
                    'RU',
                    'SE',
                    'SI',
                    'SJ',
                    'SK',
                    'SM',
                    'TR',
                    'UA',
                    'VA',
                ),
            ),
            'NA' => array(
                'name'      => __( 'North America', 'ba-book-everything' ),
                'countries' => array(
                    'AG',
                    'AI',
                    'AW',
                    'BB',
                    'BL',
                    'BM',
                    'BQ',
                    'BS',
                    'BZ',
                    'CA',
                    'CR',
                    'CU',
                    'CW',
                    'DM',
                    'DO',
                    'GD',
                    'GL',
                    'GP',
                    'GT',
                    'HN',
                    'HT',
                    'JM',
                    'KN',
                    'KY',
                    'LC',
                    'MF',
                    'MQ',
                    'MS',
                    'MX',
                    'NI',
                    'PA',
                    'PM',
                    'PR',
                    'SV',
                    'SX',
                    'TC',
                    'TT',
                    'US',
                    'VC',
                    'VG',
                    'VI',
                ),
            ),
            'OC' => array(
                'name'      => __( 'Oceania', 'ba-book-everything' ),
                'countries' => array(
                    'AS',
                    'AU',
                    'CK',
                    'FJ',
                    'FM',
                    'GU',
                    'KI',
                    'MH',
                    'MP',
                    'NC',
                    'NF',
                    'NR',
                    'NU',
                    'NZ',
                    'PF',
                    'PG',
                    'PN',
                    'PW',
                    'SB',
                    'TK',
                    'TO',
                    'TV',
                    'UM',
                    'VU',
                    'WF',
                    'WS',
                ),
            ),
            'SA' => array(
                'name'      => __( 'South America', 'ba-book-everything' ),
                'countries' => array(
                    'AR',
                    'BO',
                    'BR',
                    'CL',
                    'CO',
                    'EC',
                    'FK',
                    'GF',
                    'GY',
                    'PE',
                    'PY',
                    'SR',
                    'UY',
                    'VE',
                ),
            ),
        ]);
    }
    
///////////////////////////////////////
}